/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.SavableDigestXof;
import org.bouncycastle.crypto.digests.KeccakDigest;
import org.bouncycastle.crypto.digests.SHAKENativeDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class SHAKEDigest
extends KeccakDigest
implements SavableDigestXof {
    private static int checkBitLength(int n) {
        switch (n) {
            case 128: 
            case 256: {
                return n;
            }
        }
        throw new IllegalArgumentException("'bitStrength' " + n + " not supported for SHAKE");
    }

    public static SavableDigestXof newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest();
        }
        return new SHAKEDigest();
    }

    public SHAKEDigest() {
        this(128);
    }

    public static SavableDigestXof newInstance(CryptoServicePurpose cryptoServicePurpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(cryptoServicePurpose);
        }
        return new SHAKEDigest(cryptoServicePurpose);
    }

    public SHAKEDigest(CryptoServicePurpose cryptoServicePurpose) {
        this(128, cryptoServicePurpose);
    }

    public static SavableDigestXof newInstance(int n) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(n);
        }
        return new SHAKEDigest(n);
    }

    public SHAKEDigest(int n) {
        super(SHAKEDigest.checkBitLength(n), CryptoServicePurpose.ANY);
    }

    public static SavableDigestXof newInstance(int n, CryptoServicePurpose cryptoServicePurpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(n, cryptoServicePurpose);
        }
        return new SHAKEDigest(n, cryptoServicePurpose);
    }

    public static SavableDigestXof newInstance(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(byArray, cryptoServicePurpose);
        }
        return new SHAKEDigest(byArray, cryptoServicePurpose);
    }

    public SHAKEDigest(int n, CryptoServicePurpose cryptoServicePurpose) {
        super(SHAKEDigest.checkBitLength(n), cryptoServicePurpose);
    }

    public static SavableDigestXof newInstance(Digest digest) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE") && digest instanceof SHAKENativeDigest) {
            return new SHAKENativeDigest((SHAKENativeDigest)digest);
        }
        if (digest instanceof SHAKEDigest) {
            return new SHAKEDigest((SHAKEDigest)digest);
        }
        throw new IllegalArgumentException("digest must be either SHAKENativeDigest or SHAKEDigest");
    }

    public SHAKEDigest(SHAKEDigest sHAKEDigest) {
        super(sHAKEDigest);
    }

    public SHAKEDigest(byte[] byArray) {
        if (byArray.length != 13 + this.state.length * 8) {
            throw new IllegalArgumentException("encoded state has incorrect length");
        }
        this.bitsInQueue = Pack.bigEndianToInt(byArray, 0);
        this.rate = Pack.bigEndianToInt(byArray, 4);
        this.squeezing = Integer.MAX_VALUE == Pack.bigEndianToInt(byArray, 8);
        this.fixedOutputLength = Pack.bigEndianToInt(byArray, 12);
        int n = 16;
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = Pack.bigEndianToInt(byArray, n += 8);
        }
        this.purpose = CryptoServicePurpose.values()[byArray[n]];
    }

    public SHAKEDigest(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        this(byArray);
        this.purpose = cryptoServicePurpose;
    }

    @Override
    public String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    @Override
    public int getDigestSize() {
        return this.fixedOutputLength / 4;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return this.doFinal(byArray, n, this.getDigestSize());
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    @Override
    public int doOutput(byte[] byArray, int n, int n2) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        this.squeeze(byArray, n, (long)n2 * 8L);
        return n2;
    }

    @Override
    protected int doFinal(byte[] byArray, int n, byte by, int n2) {
        return this.doFinal(byArray, n, this.getDigestSize(), by, n2);
    }

    protected int doFinal(byte[] byArray, int n, int n2, byte by, int n3) {
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n4 = by & (1 << n3) - 1 | 15 << n3;
        int n5 = n3 + 4;
        if (n5 >= 8) {
            this.absorb((byte)n4);
            n5 -= 8;
            n4 >>>= 8;
        }
        if (n5 > 0) {
            this.absorbBits(n4, n5);
        }
        this.squeeze(byArray, n, (long)n2 * 8L);
        this.reset();
        return n2;
    }

    @Override
    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, this.purpose);
    }

    public String toString() {
        return "SHAKE[Java]()";
    }

    @Override
    public byte[] getEncodedState() {
        byte[] byArray = new byte[13 + this.state.length * 8];
        Pack.intToBigEndian(this.bitsInQueue, byArray, 0);
        Pack.intToBigEndian(this.rate, byArray, 4);
        Pack.intToBigEndian(this.squeezing ? Integer.MIN_VALUE : 0, byArray, 8);
        Pack.intToBigEndian(this.fixedOutputLength, byArray, 12);
        int n = 16;
        for (long l : this.state) {
            Pack.longToBigEndian(l, byArray, n += 8);
        }
        this.state[this.state.length - 1] = (byte)this.purpose.ordinal();
        return byArray;
    }

    @Override
    public Memoable copy() {
        return new SHAKEDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        if (!(memoable instanceof SHAKEDigest)) {
            throw new IllegalArgumentException("no SHAKEDigest instance");
        }
        this.bitsInQueue = ((SHAKEDigest)memoable).bitsInQueue;
        this.rate = ((SHAKEDigest)memoable).rate;
        this.squeezing = ((SHAKEDigest)memoable).squeezing;
        this.fixedOutputLength = ((SHAKEDigest)memoable).fixedOutputLength;
        System.arraycopy(((SHAKEDigest)memoable).state, 0, this.state, 0, this.state.length);
        this.purpose = ((SHAKEDigest)memoable).purpose;
    }
}

