/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;

public final class NettyCamelState {
    private final Exchange exchange;
    private final AsyncCallback callback;
    private final AtomicBoolean callbackCalled;
    private final AtomicBoolean exceptionCaught;

    public NettyCamelState(AsyncCallback callback, Exchange exchange) {
        this.callback = callback;
        this.exchange = exchange;
        this.callbackCalled = new AtomicBoolean();
        this.exceptionCaught = new AtomicBoolean();
    }

    public AsyncCallback getCallback() {
        return this.callback;
    }

    public boolean isDone() {
        return this.callbackCalled.get();
    }

    public void callbackDoneOnce(boolean doneSync) {
        if (!this.callbackCalled.getAndSet(true)) {
            this.callback.done(doneSync);
        }
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public void onExceptionCaught() {
        this.exceptionCaught.set(true);
    }

    public void onExceptionCaughtOnce(boolean doneSync) {
        if (this.exceptionCaught.compareAndSet(false, true)) {
            if (this.exchange.getException() == null) {
                this.exchange.setException(new IOException("Netty write operation failed"));
            }
            this.callbackDoneOnce(doneSync);
        }
    }
}

