/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class NettyComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private NettyConfiguration getOrCreateConfiguration(NettyComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new NettyConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        NettyComponent target = (NettyComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowdefaultcodec": 
            case "allowDefaultCodec": {
                this.getOrCreateConfiguration(target).setAllowDefaultCodec(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                this.getOrCreateConfiguration(target).setAllowSerializedHeaders(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "autoappenddelimiter": 
            case "autoAppendDelimiter": {
                this.getOrCreateConfiguration(target).setAutoAppendDelimiter(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "backlog": {
                this.getOrCreateConfiguration(target).setBacklog(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "bosscount": 
            case "bossCount": {
                this.getOrCreateConfiguration(target).setBossCount(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "bossgroup": 
            case "bossGroup": {
                this.getOrCreateConfiguration(target).setBossGroup(NettyComponentConfigurer.property(camelContext, EventLoopGroup.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "broadcast": {
                this.getOrCreateConfiguration(target).setBroadcast(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "channelgroup": 
            case "channelGroup": {
                this.getOrCreateConfiguration(target).setChannelGroup(NettyComponentConfigurer.property(camelContext, ChannelGroup.class, value));
                return true;
            }
            case "clientinitializerfactory": 
            case "clientInitializerFactory": {
                this.getOrCreateConfiguration(target).setClientInitializerFactory(NettyComponentConfigurer.property(camelContext, ClientInitializerFactory.class, value));
                return true;
            }
            case "clientmode": 
            case "clientMode": {
                this.getOrCreateConfiguration(target).setClientMode(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(NettyComponentConfigurer.property(camelContext, NettyConfiguration.class, value));
                return true;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                this.getOrCreateConfiguration(target).setConnectTimeout(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "correlationmanager": 
            case "correlationManager": {
                this.getOrCreateConfiguration(target).setCorrelationManager(NettyComponentConfigurer.property(camelContext, NettyCamelStateCorrelationManager.class, value));
                return true;
            }
            case "decodermaxlinelength": 
            case "decoderMaxLineLength": {
                this.getOrCreateConfiguration(target).setDecoderMaxLineLength(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "decoders": {
                this.getOrCreateConfiguration(target).setDecoders(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "delimiter": {
                this.getOrCreateConfiguration(target).setDelimiter(NettyComponentConfigurer.property(camelContext, TextLineDelimiter.class, value));
                return true;
            }
            case "disconnect": {
                this.getOrCreateConfiguration(target).setDisconnect(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "disconnectonnoreply": 
            case "disconnectOnNoReply": {
                this.getOrCreateConfiguration(target).setDisconnectOnNoReply(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "enabledprotocols": 
            case "enabledProtocols": {
                this.getOrCreateConfiguration(target).setEnabledProtocols(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "encoders": {
                this.getOrCreateConfiguration(target).setEncoders(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "encoding": {
                this.getOrCreateConfiguration(target).setEncoding(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "executorservice": 
            case "executorService": {
                target.setExecutorService(NettyComponentConfigurer.property(camelContext, EventExecutorGroup.class, value));
                return true;
            }
            case "hostnameverification": 
            case "hostnameVerification": {
                this.getOrCreateConfiguration(target).setHostnameVerification(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "keepalive": 
            case "keepAlive": {
                this.getOrCreateConfiguration(target).setKeepAlive(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "keystorefile": 
            case "keyStoreFile": {
                this.getOrCreateConfiguration(target).setKeyStoreFile(NettyComponentConfigurer.property(camelContext, File.class, value));
                return true;
            }
            case "keystoreformat": 
            case "keyStoreFormat": {
                this.getOrCreateConfiguration(target).setKeyStoreFormat(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "keystoreresource": 
            case "keyStoreResource": {
                this.getOrCreateConfiguration(target).setKeyStoreResource(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazychannelcreation": 
            case "lazyChannelCreation": {
                this.getOrCreateConfiguration(target).setLazyChannelCreation(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maximumpoolsize": 
            case "maximumPoolSize": {
                target.setMaximumPoolSize(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "nativetransport": 
            case "nativeTransport": {
                this.getOrCreateConfiguration(target).setNativeTransport(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "needclientauth": 
            case "needClientAuth": {
                this.getOrCreateConfiguration(target).setNeedClientAuth(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "nettyserverbootstrapfactory": 
            case "nettyServerBootstrapFactory": {
                this.getOrCreateConfiguration(target).setNettyServerBootstrapFactory(NettyComponentConfigurer.property(camelContext, NettyServerBootstrapFactory.class, value));
                return true;
            }
            case "networkinterface": 
            case "networkInterface": {
                this.getOrCreateConfiguration(target).setNetworkInterface(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "noreplyloglevel": 
            case "noReplyLogLevel": {
                this.getOrCreateConfiguration(target).setNoReplyLogLevel(NettyComponentConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "options": {
                this.getOrCreateConfiguration(target).setOptions(NettyComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "passphrase": {
                this.getOrCreateConfiguration(target).setPassphrase(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "producerpoolblockwhenexhausted": 
            case "producerPoolBlockWhenExhausted": {
                this.getOrCreateConfiguration(target).setProducerPoolBlockWhenExhausted(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "producerpoolenabled": 
            case "producerPoolEnabled": {
                this.getOrCreateConfiguration(target).setProducerPoolEnabled(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "producerpoolmaxidle": 
            case "producerPoolMaxIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMaxIdle(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "producerpoolmaxtotal": 
            case "producerPoolMaxTotal": {
                this.getOrCreateConfiguration(target).setProducerPoolMaxTotal(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "producerpoolmaxwait": 
            case "producerPoolMaxWait": {
                this.getOrCreateConfiguration(target).setProducerPoolMaxWait(NettyComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "producerpoolminevictableidle": 
            case "producerPoolMinEvictableIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMinEvictableIdle(NettyComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "producerpoolminidle": 
            case "producerPoolMinIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMinIdle(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                this.getOrCreateConfiguration(target).setReceiveBufferSize(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "receivebuffersizepredictor": 
            case "receiveBufferSizePredictor": {
                this.getOrCreateConfiguration(target).setReceiveBufferSizePredictor(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "reconnect": {
                this.getOrCreateConfiguration(target).setReconnect(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "reconnectinterval": 
            case "reconnectInterval": {
                this.getOrCreateConfiguration(target).setReconnectInterval(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                this.getOrCreateConfiguration(target).setRequestTimeout(NettyComponentConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "reuseaddress": 
            case "reuseAddress": {
                this.getOrCreateConfiguration(target).setReuseAddress(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "reusechannel": 
            case "reuseChannel": {
                this.getOrCreateConfiguration(target).setReuseChannel(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "securityprovider": 
            case "securityProvider": {
                this.getOrCreateConfiguration(target).setSecurityProvider(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                this.getOrCreateConfiguration(target).setSendBufferSize(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "serverclosedchannelexceptioncaughtloglevel": 
            case "serverClosedChannelExceptionCaughtLogLevel": {
                this.getOrCreateConfiguration(target).setServerClosedChannelExceptionCaughtLogLevel(NettyComponentConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "serverexceptioncaughtloglevel": 
            case "serverExceptionCaughtLogLevel": {
                this.getOrCreateConfiguration(target).setServerExceptionCaughtLogLevel(NettyComponentConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "serverinitializerfactory": 
            case "serverInitializerFactory": {
                this.getOrCreateConfiguration(target).setServerInitializerFactory(NettyComponentConfigurer.property(camelContext, ServerInitializerFactory.class, value));
                return true;
            }
            case "ssl": {
                this.getOrCreateConfiguration(target).setSsl(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "sslclientcertheaders": 
            case "sslClientCertHeaders": {
                this.getOrCreateConfiguration(target).setSslClientCertHeaders(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters(NettyComponentConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "sslhandler": 
            case "sslHandler": {
                this.getOrCreateConfiguration(target).setSslHandler(NettyComponentConfigurer.property(camelContext, SslHandler.class, value));
                return true;
            }
            case "sync": {
                this.getOrCreateConfiguration(target).setSync(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                this.getOrCreateConfiguration(target).setTcpNoDelay(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "textline": {
                this.getOrCreateConfiguration(target).setTextline(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "transferexchange": 
            case "transferExchange": {
                this.getOrCreateConfiguration(target).setTransferExchange(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "truststorefile": 
            case "trustStoreFile": {
                this.getOrCreateConfiguration(target).setTrustStoreFile(NettyComponentConfigurer.property(camelContext, File.class, value));
                return true;
            }
            case "truststoreresource": 
            case "trustStoreResource": {
                this.getOrCreateConfiguration(target).setTrustStoreResource(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "udpbytearraycodec": 
            case "udpByteArrayCodec": {
                this.getOrCreateConfiguration(target).setUdpByteArrayCodec(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "udpconnectionlesssending": 
            case "udpConnectionlessSending": {
                this.getOrCreateConfiguration(target).setUdpConnectionlessSending(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "unixdomainsocketpath": 
            case "unixDomainSocketPath": {
                this.getOrCreateConfiguration(target).setUnixDomainSocketPath(NettyComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "usebytebuf": 
            case "useByteBuf": {
                this.getOrCreateConfiguration(target).setUseByteBuf(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "usingexecutorservice": 
            case "usingExecutorService": {
                this.getOrCreateConfiguration(target).setUsingExecutorService(NettyComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "workercount": 
            case "workerCount": {
                this.getOrCreateConfiguration(target).setWorkerCount(NettyComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "workergroup": 
            case "workerGroup": {
                this.getOrCreateConfiguration(target).setWorkerGroup(NettyComponentConfigurer.property(camelContext, EventLoopGroup.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowdefaultcodec": 
            case "allowDefaultCodec": {
                return Boolean.TYPE;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return Boolean.TYPE;
            }
            case "autoappenddelimiter": 
            case "autoAppendDelimiter": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "backlog": {
                return Integer.TYPE;
            }
            case "bosscount": 
            case "bossCount": {
                return Integer.TYPE;
            }
            case "bossgroup": 
            case "bossGroup": {
                return EventLoopGroup.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "broadcast": {
                return Boolean.TYPE;
            }
            case "channelgroup": 
            case "channelGroup": {
                return ChannelGroup.class;
            }
            case "clientinitializerfactory": 
            case "clientInitializerFactory": {
                return ClientInitializerFactory.class;
            }
            case "clientmode": 
            case "clientMode": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return NettyConfiguration.class;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return Integer.TYPE;
            }
            case "correlationmanager": 
            case "correlationManager": {
                return NettyCamelStateCorrelationManager.class;
            }
            case "decodermaxlinelength": 
            case "decoderMaxLineLength": {
                return Integer.TYPE;
            }
            case "decoders": {
                return String.class;
            }
            case "delimiter": {
                return TextLineDelimiter.class;
            }
            case "disconnect": {
                return Boolean.TYPE;
            }
            case "disconnectonnoreply": 
            case "disconnectOnNoReply": {
                return Boolean.TYPE;
            }
            case "enabledprotocols": 
            case "enabledProtocols": {
                return String.class;
            }
            case "encoders": {
                return String.class;
            }
            case "encoding": {
                return String.class;
            }
            case "executorservice": 
            case "executorService": {
                return EventExecutorGroup.class;
            }
            case "hostnameverification": 
            case "hostnameVerification": {
                return Boolean.TYPE;
            }
            case "keepalive": 
            case "keepAlive": {
                return Boolean.TYPE;
            }
            case "keystorefile": 
            case "keyStoreFile": {
                return File.class;
            }
            case "keystoreformat": 
            case "keyStoreFormat": {
                return String.class;
            }
            case "keystoreresource": 
            case "keyStoreResource": {
                return String.class;
            }
            case "lazychannelcreation": 
            case "lazyChannelCreation": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maximumpoolsize": 
            case "maximumPoolSize": {
                return Integer.TYPE;
            }
            case "nativetransport": 
            case "nativeTransport": {
                return Boolean.TYPE;
            }
            case "needclientauth": 
            case "needClientAuth": {
                return Boolean.TYPE;
            }
            case "nettyserverbootstrapfactory": 
            case "nettyServerBootstrapFactory": {
                return NettyServerBootstrapFactory.class;
            }
            case "networkinterface": 
            case "networkInterface": {
                return String.class;
            }
            case "noreplyloglevel": 
            case "noReplyLogLevel": {
                return LoggingLevel.class;
            }
            case "options": {
                return Map.class;
            }
            case "passphrase": {
                return String.class;
            }
            case "producerpoolblockwhenexhausted": 
            case "producerPoolBlockWhenExhausted": {
                return Boolean.TYPE;
            }
            case "producerpoolenabled": 
            case "producerPoolEnabled": {
                return Boolean.TYPE;
            }
            case "producerpoolmaxidle": 
            case "producerPoolMaxIdle": {
                return Integer.TYPE;
            }
            case "producerpoolmaxtotal": 
            case "producerPoolMaxTotal": {
                return Integer.TYPE;
            }
            case "producerpoolmaxwait": 
            case "producerPoolMaxWait": {
                return Long.TYPE;
            }
            case "producerpoolminevictableidle": 
            case "producerPoolMinEvictableIdle": {
                return Long.TYPE;
            }
            case "producerpoolminidle": 
            case "producerPoolMinIdle": {
                return Integer.TYPE;
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                return Integer.TYPE;
            }
            case "receivebuffersizepredictor": 
            case "receiveBufferSizePredictor": {
                return Integer.TYPE;
            }
            case "reconnect": {
                return Boolean.TYPE;
            }
            case "reconnectinterval": 
            case "reconnectInterval": {
                return Integer.TYPE;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return Long.TYPE;
            }
            case "reuseaddress": 
            case "reuseAddress": {
                return Boolean.TYPE;
            }
            case "reusechannel": 
            case "reuseChannel": {
                return Boolean.TYPE;
            }
            case "securityprovider": 
            case "securityProvider": {
                return String.class;
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                return Integer.TYPE;
            }
            case "serverclosedchannelexceptioncaughtloglevel": 
            case "serverClosedChannelExceptionCaughtLogLevel": {
                return LoggingLevel.class;
            }
            case "serverexceptioncaughtloglevel": 
            case "serverExceptionCaughtLogLevel": {
                return LoggingLevel.class;
            }
            case "serverinitializerfactory": 
            case "serverInitializerFactory": {
                return ServerInitializerFactory.class;
            }
            case "ssl": {
                return Boolean.TYPE;
            }
            case "sslclientcertheaders": 
            case "sslClientCertHeaders": {
                return Boolean.TYPE;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "sslhandler": 
            case "sslHandler": {
                return SslHandler.class;
            }
            case "sync": {
                return Boolean.TYPE;
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                return Boolean.TYPE;
            }
            case "textline": {
                return Boolean.TYPE;
            }
            case "transferexchange": 
            case "transferExchange": {
                return Boolean.TYPE;
            }
            case "truststorefile": 
            case "trustStoreFile": {
                return File.class;
            }
            case "truststoreresource": 
            case "trustStoreResource": {
                return String.class;
            }
            case "udpbytearraycodec": 
            case "udpByteArrayCodec": {
                return Boolean.TYPE;
            }
            case "udpconnectionlesssending": 
            case "udpConnectionlessSending": {
                return Boolean.TYPE;
            }
            case "unixdomainsocketpath": 
            case "unixDomainSocketPath": {
                return String.class;
            }
            case "usebytebuf": 
            case "useByteBuf": {
                return Boolean.TYPE;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return Boolean.TYPE;
            }
            case "usingexecutorservice": 
            case "usingExecutorService": {
                return Boolean.TYPE;
            }
            case "workercount": 
            case "workerCount": {
                return Integer.TYPE;
            }
            case "workergroup": 
            case "workerGroup": {
                return EventLoopGroup.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        NettyComponent target = (NettyComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowdefaultcodec": 
            case "allowDefaultCodec": {
                return this.getOrCreateConfiguration(target).isAllowDefaultCodec();
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return this.getOrCreateConfiguration(target).isAllowSerializedHeaders();
            }
            case "autoappenddelimiter": 
            case "autoAppendDelimiter": {
                return this.getOrCreateConfiguration(target).isAutoAppendDelimiter();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "backlog": {
                return this.getOrCreateConfiguration(target).getBacklog();
            }
            case "bosscount": 
            case "bossCount": {
                return this.getOrCreateConfiguration(target).getBossCount();
            }
            case "bossgroup": 
            case "bossGroup": {
                return this.getOrCreateConfiguration(target).getBossGroup();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "broadcast": {
                return this.getOrCreateConfiguration(target).isBroadcast();
            }
            case "channelgroup": 
            case "channelGroup": {
                return this.getOrCreateConfiguration(target).getChannelGroup();
            }
            case "clientinitializerfactory": 
            case "clientInitializerFactory": {
                return this.getOrCreateConfiguration(target).getClientInitializerFactory();
            }
            case "clientmode": 
            case "clientMode": {
                return this.getOrCreateConfiguration(target).isClientMode();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return this.getOrCreateConfiguration(target).getConnectTimeout();
            }
            case "correlationmanager": 
            case "correlationManager": {
                return this.getOrCreateConfiguration(target).getCorrelationManager();
            }
            case "decodermaxlinelength": 
            case "decoderMaxLineLength": {
                return this.getOrCreateConfiguration(target).getDecoderMaxLineLength();
            }
            case "decoders": {
                return this.getOrCreateConfiguration(target).getDecoders();
            }
            case "delimiter": {
                return this.getOrCreateConfiguration(target).getDelimiter();
            }
            case "disconnect": {
                return this.getOrCreateConfiguration(target).isDisconnect();
            }
            case "disconnectonnoreply": 
            case "disconnectOnNoReply": {
                return this.getOrCreateConfiguration(target).isDisconnectOnNoReply();
            }
            case "enabledprotocols": 
            case "enabledProtocols": {
                return this.getOrCreateConfiguration(target).getEnabledProtocols();
            }
            case "encoders": {
                return this.getOrCreateConfiguration(target).getEncoders();
            }
            case "encoding": {
                return this.getOrCreateConfiguration(target).getEncoding();
            }
            case "executorservice": 
            case "executorService": {
                return target.getExecutorService();
            }
            case "hostnameverification": 
            case "hostnameVerification": {
                return this.getOrCreateConfiguration(target).isHostnameVerification();
            }
            case "keepalive": 
            case "keepAlive": {
                return this.getOrCreateConfiguration(target).isKeepAlive();
            }
            case "keystorefile": 
            case "keyStoreFile": {
                return this.getOrCreateConfiguration(target).getKeyStoreFile();
            }
            case "keystoreformat": 
            case "keyStoreFormat": {
                return this.getOrCreateConfiguration(target).getKeyStoreFormat();
            }
            case "keystoreresource": 
            case "keyStoreResource": {
                return this.getOrCreateConfiguration(target).getKeyStoreResource();
            }
            case "lazychannelcreation": 
            case "lazyChannelCreation": {
                return this.getOrCreateConfiguration(target).isLazyChannelCreation();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maximumpoolsize": 
            case "maximumPoolSize": {
                return target.getMaximumPoolSize();
            }
            case "nativetransport": 
            case "nativeTransport": {
                return this.getOrCreateConfiguration(target).isNativeTransport();
            }
            case "needclientauth": 
            case "needClientAuth": {
                return this.getOrCreateConfiguration(target).isNeedClientAuth();
            }
            case "nettyserverbootstrapfactory": 
            case "nettyServerBootstrapFactory": {
                return this.getOrCreateConfiguration(target).getNettyServerBootstrapFactory();
            }
            case "networkinterface": 
            case "networkInterface": {
                return this.getOrCreateConfiguration(target).getNetworkInterface();
            }
            case "noreplyloglevel": 
            case "noReplyLogLevel": {
                return this.getOrCreateConfiguration(target).getNoReplyLogLevel();
            }
            case "options": {
                return this.getOrCreateConfiguration(target).getOptions();
            }
            case "passphrase": {
                return this.getOrCreateConfiguration(target).getPassphrase();
            }
            case "producerpoolblockwhenexhausted": 
            case "producerPoolBlockWhenExhausted": {
                return this.getOrCreateConfiguration(target).isProducerPoolBlockWhenExhausted();
            }
            case "producerpoolenabled": 
            case "producerPoolEnabled": {
                return this.getOrCreateConfiguration(target).isProducerPoolEnabled();
            }
            case "producerpoolmaxidle": 
            case "producerPoolMaxIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMaxIdle();
            }
            case "producerpoolmaxtotal": 
            case "producerPoolMaxTotal": {
                return this.getOrCreateConfiguration(target).getProducerPoolMaxTotal();
            }
            case "producerpoolmaxwait": 
            case "producerPoolMaxWait": {
                return this.getOrCreateConfiguration(target).getProducerPoolMaxWait();
            }
            case "producerpoolminevictableidle": 
            case "producerPoolMinEvictableIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMinEvictableIdle();
            }
            case "producerpoolminidle": 
            case "producerPoolMinIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMinIdle();
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                return this.getOrCreateConfiguration(target).getReceiveBufferSize();
            }
            case "receivebuffersizepredictor": 
            case "receiveBufferSizePredictor": {
                return this.getOrCreateConfiguration(target).getReceiveBufferSizePredictor();
            }
            case "reconnect": {
                return this.getOrCreateConfiguration(target).isReconnect();
            }
            case "reconnectinterval": 
            case "reconnectInterval": {
                return this.getOrCreateConfiguration(target).getReconnectInterval();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return this.getOrCreateConfiguration(target).getRequestTimeout();
            }
            case "reuseaddress": 
            case "reuseAddress": {
                return this.getOrCreateConfiguration(target).isReuseAddress();
            }
            case "reusechannel": 
            case "reuseChannel": {
                return this.getOrCreateConfiguration(target).isReuseChannel();
            }
            case "securityprovider": 
            case "securityProvider": {
                return this.getOrCreateConfiguration(target).getSecurityProvider();
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                return this.getOrCreateConfiguration(target).getSendBufferSize();
            }
            case "serverclosedchannelexceptioncaughtloglevel": 
            case "serverClosedChannelExceptionCaughtLogLevel": {
                return this.getOrCreateConfiguration(target).getServerClosedChannelExceptionCaughtLogLevel();
            }
            case "serverexceptioncaughtloglevel": 
            case "serverExceptionCaughtLogLevel": {
                return this.getOrCreateConfiguration(target).getServerExceptionCaughtLogLevel();
            }
            case "serverinitializerfactory": 
            case "serverInitializerFactory": {
                return this.getOrCreateConfiguration(target).getServerInitializerFactory();
            }
            case "ssl": {
                return this.getOrCreateConfiguration(target).isSsl();
            }
            case "sslclientcertheaders": 
            case "sslClientCertHeaders": {
                return this.getOrCreateConfiguration(target).isSslClientCertHeaders();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "sslhandler": 
            case "sslHandler": {
                return this.getOrCreateConfiguration(target).getSslHandler();
            }
            case "sync": {
                return this.getOrCreateConfiguration(target).isSync();
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                return this.getOrCreateConfiguration(target).isTcpNoDelay();
            }
            case "textline": {
                return this.getOrCreateConfiguration(target).isTextline();
            }
            case "transferexchange": 
            case "transferExchange": {
                return this.getOrCreateConfiguration(target).isTransferExchange();
            }
            case "truststorefile": 
            case "trustStoreFile": {
                return this.getOrCreateConfiguration(target).getTrustStoreFile();
            }
            case "truststoreresource": 
            case "trustStoreResource": {
                return this.getOrCreateConfiguration(target).getTrustStoreResource();
            }
            case "udpbytearraycodec": 
            case "udpByteArrayCodec": {
                return this.getOrCreateConfiguration(target).isUdpByteArrayCodec();
            }
            case "udpconnectionlesssending": 
            case "udpConnectionlessSending": {
                return this.getOrCreateConfiguration(target).isUdpConnectionlessSending();
            }
            case "unixdomainsocketpath": 
            case "unixDomainSocketPath": {
                return this.getOrCreateConfiguration(target).getUnixDomainSocketPath();
            }
            case "usebytebuf": 
            case "useByteBuf": {
                return this.getOrCreateConfiguration(target).isUseByteBuf();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "usingexecutorservice": 
            case "usingExecutorService": {
                return this.getOrCreateConfiguration(target).isUsingExecutorService();
            }
            case "workercount": 
            case "workerCount": {
                return this.getOrCreateConfiguration(target).getWorkerCount();
            }
            case "workergroup": 
            case "workerGroup": {
                return this.getOrCreateConfiguration(target).getWorkerGroup();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "options": {
                return Object.class;
            }
        }
        return null;
    }
}

