/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite.operation.repository;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.component.nitrite.operation.AbstractPayloadAwareOperation;
import org.apache.camel.component.nitrite.operation.RepositoryOperation;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.ObjectRepository;

public class UpdateRepositoryOperation
extends AbstractPayloadAwareOperation
implements RepositoryOperation {
    private ObjectFilter filter;

    public UpdateRepositoryOperation(ObjectFilter filter) {
        this.filter = filter;
    }

    public UpdateRepositoryOperation(ObjectFilter filter, Object payload) {
        super(payload);
        this.filter = filter;
    }

    public UpdateRepositoryOperation(ObjectFilter filter, Expression documentExpression) {
        super(documentExpression);
        this.filter = filter;
    }

    @Override
    protected void execute(Exchange exchange, NitriteEndpoint endpoint) throws Exception {
        ObjectRepository repository = (ObjectRepository)endpoint.getNitriteCollection();
        Object payload = this.getPayload(exchange, endpoint);
        if (this.filter != null) {
            exchange.getMessage().setHeader("CamelNitriteWriteResult", repository.update(this.filter, payload));
        } else {
            exchange.getMessage().setHeader("CamelNitriteWriteResult", repository.update(payload));
        }
    }
}

