/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.store;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.meta.Attributes;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.util.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

class NitriteMVMap<Key, Value>
implements NitriteMap<Key, Value> {
    private final MVMap<Key, Value> mvMap;
    private final NitriteStore nitriteStore;
    private final MVStore mvStore;

    NitriteMVMap(MVMap<Key, Value> mvMap, NitriteStore nitriteStore) {
        this.mvMap = mvMap;
        this.nitriteStore = nitriteStore;
        this.mvStore = mvMap.store;
    }

    @Override
    public boolean containsKey(Key key) {
        return this.mvMap.containsKey(key);
    }

    @Override
    public Value get(Key key) {
        return this.mvMap.get(key);
    }

    @Override
    public NitriteStore getStore() {
        return this.nitriteStore;
    }

    @Override
    public void clear() {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            this.updateAttributes();
            this.mvMap.clear();
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public String getName() {
        return this.mvMap.getName();
    }

    @Override
    public Collection<Value> values() {
        return this.mvMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value remove(Key key) {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            this.updateAttributes();
            Value Value2 = this.mvMap.remove(key);
            return Value2;
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public Set<Key> keySet() {
        return this.mvMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Key key, Value value) {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            this.updateAttributes();
            this.mvMap.put(key, value);
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public int size() {
        return this.mvMap.size();
    }

    @Override
    public long sizeAsLong() {
        return this.mvMap.sizeAsLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value putIfAbsent(Key nitriteId, Value document) {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            this.updateAttributes();
            Value Value2 = this.mvMap.putIfAbsent(nitriteId, document);
            return Value2;
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return this.mvMap.entrySet();
    }

    @Override
    public Key higherKey(Key key) {
        return this.mvMap.higherKey(key);
    }

    @Override
    public Key ceilingKey(Key key) {
        return this.mvMap.ceilingKey(key);
    }

    @Override
    public Key lowerKey(Key key) {
        return this.mvMap.lowerKey(key);
    }

    @Override
    public Key floorKey(Key key) {
        return this.mvMap.floorKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mvMap.isEmpty();
    }

    @Override
    public List<Key> keyList() {
        return this.mvMap.keyList();
    }

    @Override
    public Attributes getAttributes() {
        NitriteMap<String, Attributes> metaMap = this.nitriteStore.metaMap();
        if (metaMap != null && !this.getName().contentEquals("$nitrite_meta_map")) {
            return metaMap.get(this.getName());
        }
        return null;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        NitriteMap<String, Attributes> metaMap = this.nitriteStore.metaMap();
        if (metaMap != null && !this.getName().contentEquals("$nitrite_meta_map")) {
            metaMap.put(this.getName(), attributes);
        }
    }

    MVMap<Key, Value> getUnderlyingMVMap() {
        return this.mvMap;
    }

    private void updateAttributes() {
        if (StringUtils.isNullOrEmpty(this.getName()) || "$nitrite_meta_map".equals(this.getName())) {
            return;
        }
        NitriteMap<String, Attributes> metaMap = this.nitriteStore.metaMap();
        if (metaMap != null) {
            Attributes attributes = metaMap.get(this.getName());
            if (attributes == null) {
                attributes = new Attributes(this.getName());
                metaMap.put(this.getName(), attributes);
            }
            attributes.setLastModifiedTime(System.currentTimeMillis());
        }
    }
}

