/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.event;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.dizitart.no2.NitriteContext;
import org.dizitart.no2.event.EventBus;

public abstract class NitriteEventBus<EventInfo, EventListener>
implements EventBus<EventInfo, EventListener> {
    private Set<EventListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private ExecutorService eventExecutor;

    public NitriteEventBus(NitriteContext context) {
        this.eventExecutor = context.getWorkerPool();
    }

    @Override
    public void register(EventListener eventListener) {
        if (eventListener != null) {
            this.listeners.add(eventListener);
        }
    }

    @Override
    public void deregister(EventListener eventListener) {
        if (eventListener != null) {
            this.listeners.remove(eventListener);
        }
    }

    @Override
    public void close() {
        this.listeners.clear();
    }

    protected ExecutorService getEventExecutor() {
        return this.eventExecutor;
    }

    protected Set<EventListener> getListeners() {
        return this.listeners;
    }
}

