/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.tool;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.Index;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.PersistentCollection;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.objects.ObjectRepository;
import org.dizitart.no2.tool.ExportOptions;

class NitriteJsonExporter {
    private Nitrite db;
    private JsonGenerator generator;
    private ExportOptions options;
    private NitriteMapper nitriteMapper;

    public NitriteJsonExporter(Nitrite db) {
        this.db = db;
        this.nitriteMapper = db.getContext().getNitriteMapper();
    }

    public void setGenerator(JsonGenerator generator) {
        this.generator = generator;
    }

    public void exportData() throws IOException, ClassNotFoundException {
        List<PersistentCollection<?>> collections = this.options.getCollections();
        if (collections.isEmpty()) {
            Set<String> collectionNames = this.db.listCollectionNames();
            Set<String> repositoryNames = this.db.listRepositories();
            this.generator.writeStartObject();
            this.generator.writeFieldName("collections");
            this.generator.writeStartArray();
            for (String collectionName : collectionNames) {
                NitriteCollection nitriteCollection = this.db.getCollection(collectionName);
                this.writeCollection(nitriteCollection);
            }
            this.generator.writeEndArray();
            this.generator.writeFieldName("repositories");
            this.generator.writeStartArray();
            for (String repoName : repositoryNames) {
                Class<?> type = Class.forName(repoName);
                ObjectRepository<?> repository = this.db.getRepository(type);
                this.writeRepository(repository);
            }
            this.generator.writeEndArray();
            this.generator.writeEndObject();
        } else {
            for (PersistentCollection<?> collection : collections) {
                if (collection == null) continue;
                this.generator.writeStartObject();
                if (collection instanceof NitriteCollection) {
                    NitriteCollection nitriteCollection = (NitriteCollection)collection;
                    this.generator.writeFieldName("collections");
                    this.generator.writeStartArray();
                    this.writeCollection(nitriteCollection);
                    this.generator.writeEndArray();
                } else if (collection instanceof ObjectRepository) {
                    ObjectRepository repository = (ObjectRepository)collection;
                    this.generator.writeFieldName("repositories");
                    this.generator.writeStartArray();
                    this.writeRepository(repository);
                    this.generator.writeEndArray();
                }
                this.generator.writeEndObject();
            }
        }
        this.generator.close();
    }

    private void writeRepository(ObjectRepository<?> repository) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeFieldName("type");
        this.generator.writeString(repository.getType().getName());
        Collection<Index> indices = repository.listIndices();
        this.writeIndices(indices);
        Cursor cursor = repository.getDocumentCollection().find();
        this.writeContent(cursor);
        this.generator.writeEndObject();
    }

    private void writeCollection(NitriteCollection nitriteCollection) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeFieldName("name");
        this.generator.writeString(nitriteCollection.getName());
        Collection<Index> indices = nitriteCollection.listIndices();
        this.writeIndices(indices);
        Cursor cursor = nitriteCollection.find();
        this.writeContent(cursor);
        this.generator.writeEndObject();
    }

    private void writeIndices(Collection<Index> indices) throws IOException {
        this.generator.writeFieldName("indices");
        this.generator.writeStartArray();
        if (this.options.isExportIndices()) {
            for (Index index : indices) {
                this.generator.writeStartObject();
                this.generator.writeFieldName("index");
                this.generator.writeObject(index);
                this.generator.writeEndObject();
            }
        }
        this.generator.writeEndArray();
    }

    private void writeContent(Cursor cursor) throws IOException {
        this.generator.writeFieldName("data");
        this.generator.writeStartArray();
        if (this.options.isExportData()) {
            for (Document document : cursor) {
                this.generator.writeStartObject();
                this.generator.writeFieldName("key");
                this.generator.writeObject(document.get("_id"));
                this.generator.writeFieldName("value");
                this.generator.writeObject(document);
                this.generator.writeEndObject();
            }
        }
        this.generator.writeEndArray();
    }

    public void setOptions(ExportOptions options) {
        this.options = options;
    }
}

