/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.olingo2.api.Olingo2App;
import org.apache.camel.component.olingo2.api.Olingo2ResponseHandler;
import org.apache.camel.util.ObjectHelper;
import org.apache.olingo.odata2.api.edm.Edm;

public class Olingo2AppWrapper {
    private final Olingo2App olingo2App;
    private volatile Edm edm;

    public Olingo2AppWrapper(Olingo2App olingo2App) {
        ObjectHelper.notNull(olingo2App, "olingo2App");
        this.olingo2App = olingo2App;
    }

    public Olingo2App getOlingo2App() {
        return this.olingo2App;
    }

    public void close() {
        this.olingo2App.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edm getEdm(Map<String, String> endpointHttpHeaders) throws RuntimeCamelException {
        Edm localEdm = this.edm;
        if (localEdm == null) {
            Olingo2AppWrapper olingo2AppWrapper = this;
            synchronized (olingo2AppWrapper) {
                localEdm = this.edm;
                if (localEdm == null) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    final Exception[] error = new Exception[1];
                    this.olingo2App.read(null, "$metadata", null, endpointHttpHeaders, new Olingo2ResponseHandler<Edm>(){

                        @Override
                        public void onResponse(Edm response, Map<String, String> responseHeaders) {
                            Olingo2AppWrapper.this.edm = response;
                            latch.countDown();
                        }

                        @Override
                        public void onException(Exception ex) {
                            error[0] = ex;
                            latch.countDown();
                        }

                        @Override
                        public void onCanceled() {
                            error[0] = new RuntimeCamelException("OData HTTP request cancelled!");
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                        Exception ex = error[0];
                        if (ex != null) {
                            if (ex instanceof RuntimeCamelException) {
                                throw (RuntimeCamelException)ex;
                            }
                            String message = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getName();
                            throw new RuntimeCamelException("Error reading EDM: " + message, ex);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeCamelException(e.getMessage(), e);
                    }
                    localEdm = this.edm;
                }
            }
        }
        return localEdm;
    }
}

