/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.servicedocument;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmEntitySetInfo;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.servicedocument.AtomInfo;
import org.apache.olingo.odata2.api.servicedocument.Collection;
import org.apache.olingo.odata2.api.servicedocument.CommonAttributes;
import org.apache.olingo.odata2.api.servicedocument.ExtensionElement;
import org.apache.olingo.odata2.api.servicedocument.Workspace;
import org.apache.olingo.odata2.core.commons.Decoder;
import org.apache.olingo.odata2.core.edm.provider.EdmEntitySetInfoImplProv;

public class AtomInfoImpl
implements AtomInfo {
    private List<Workspace> workspaces;
    private CommonAttributes attributes;
    private List<ExtensionElement> extensionElements;

    @Override
    public CommonAttributes getCommonAttributes() {
        return this.attributes;
    }

    @Override
    public List<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    @Override
    public List<ExtensionElement> getExtesionElements() {
        return this.extensionElements;
    }

    public AtomInfoImpl setWorkspaces(List<Workspace> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    public AtomInfoImpl setCommonAttributes(CommonAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public AtomInfoImpl setExtesionElements(List<ExtensionElement> elements) {
        this.extensionElements = elements;
        return this;
    }

    public List<EdmEntitySetInfo> getEntitySetsInfo() throws EntityProviderException {
        ArrayList<EdmEntitySetInfo> entitySets = new ArrayList<EdmEntitySetInfo>();
        for (Workspace workspace : this.workspaces) {
            for (Collection collection : workspace.getCollections()) {
                String[] names = collection.getHref().split("\\.(?=[^.]+$)");
                try {
                    EdmEntitySetInfoImplProv entitySetInfo;
                    EntityContainerInfo container;
                    EntitySet entitySet;
                    if (names.length == 1) {
                        entitySet = new EntitySet().setName(Decoder.decode(names[0]));
                        container = new EntityContainerInfo().setDefaultEntityContainer(true);
                        entitySetInfo = new EdmEntitySetInfoImplProv(entitySet, container);
                        entitySets.add(entitySetInfo);
                        continue;
                    }
                    if (names.length != 2) continue;
                    entitySet = new EntitySet().setName(Decoder.decode(names[1]));
                    container = new EntityContainerInfo().setName(Decoder.decode(names[0])).setDefaultEntityContainer(false);
                    entitySetInfo = new EdmEntitySetInfoImplProv(entitySet, container);
                    entitySets.add(entitySetInfo);
                }
                catch (EdmException e) {
                    throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
                }
            }
        }
        return entitySets;
    }
}

