/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExceptionVisitExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.api.uri.expression.UnaryOperator;
import org.apache.olingo.odata2.core.uri.expression.InfoUnaryOperator;

public class UnaryExpressionImpl
implements UnaryExpression {
    private InfoUnaryOperator operatorInfo = null;
    private CommonExpression operand = null;
    private EdmType edmType = null;

    public UnaryExpressionImpl(InfoUnaryOperator operatorInfo, CommonExpression operand) {
        this.operatorInfo = operatorInfo;
        this.operand = operand;
    }

    @Override
    public ExpressionKind getKind() {
        return ExpressionKind.UNARY;
    }

    @Override
    public UnaryOperator getOperator() {
        return this.operatorInfo.operator;
    }

    @Override
    public CommonExpression getOperand() {
        return this.operand;
    }

    @Override
    public EdmType getEdmType() {
        return this.edmType;
    }

    @Override
    public CommonExpression setEdmType(EdmType edmType) {
        this.edmType = edmType;
        return this;
    }

    @Override
    public String getUriLiteral() {
        return this.operatorInfo.getSyntax();
    }

    @Override
    public Object accept(ExpressionVisitor visitor) throws ExceptionVisitExpression, ODataApplicationException {
        Object retOperand = this.operand.accept(visitor);
        return visitor.visitUnary(this, this.operatorInfo.getOperator(), retOperand);
    }
}

