/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2;

import java.util.Map;
import org.apache.camel.component.olingo2.internal.Olingo2ApiName;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;

@UriParams
@Configurer(extended=true)
public class Olingo2Configuration {
    private static final String DEFAULT_CONTENT_TYPE = ContentType.APPLICATION_JSON.toString();
    private static final int DEFAULT_TIMEOUT = 30000;
    @UriPath
    @Metadata(required=true)
    private Olingo2ApiName apiName;
    @UriPath
    @Metadata(required=true)
    private String methodName;
    @UriParam
    private String serviceUri;
    @UriParam(defaultValue="application/json;charset=utf-8")
    private String contentType = DEFAULT_CONTENT_TYPE;
    @UriParam
    private Map<String, String> httpHeaders;
    @UriParam
    private EntityProviderReadProperties entityProviderReadProperties;
    @UriParam
    private EntityProviderWriteProperties entityProviderWriteProperties;
    @UriParam(defaultValue="30000")
    private int connectTimeout = 30000;
    @UriParam(defaultValue="30000")
    private int socketTimeout = 30000;
    @UriParam
    private HttpHost proxy;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="advanced")
    private HttpAsyncClientBuilder httpAsyncClientBuilder;
    @UriParam(label="advanced")
    private HttpClientBuilder httpClientBuilder;
    @UriParam
    private boolean filterAlreadySeen;
    @UriParam(label="consumer", defaultValue="true")
    private boolean splitResult = true;

    public Olingo2ApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(Olingo2ApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public void setServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public EntityProviderReadProperties getEntityProviderReadProperties() {
        return this.entityProviderReadProperties;
    }

    public void setEntityProviderReadProperties(EntityProviderReadProperties entityProviderReadProperties) {
        this.entityProviderReadProperties = entityProviderReadProperties;
    }

    public EntityProviderWriteProperties getEntityProviderWriteProperties() {
        return this.entityProviderWriteProperties;
    }

    public void setEntityProviderWriteProperties(EntityProviderWriteProperties entityProviderWriteProperties) {
        this.entityProviderWriteProperties = entityProviderWriteProperties;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public HttpAsyncClientBuilder getHttpAsyncClientBuilder() {
        return this.httpAsyncClientBuilder;
    }

    public void setHttpAsyncClientBuilder(HttpAsyncClientBuilder httpAsyncClientBuilder) {
        this.httpAsyncClientBuilder = httpAsyncClientBuilder;
    }

    public HttpClientBuilder getHttpClientBuilder() {
        return this.httpClientBuilder;
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    public boolean isFilterAlreadySeen() {
        return this.filterAlreadySeen;
    }

    public void setFilterAlreadySeen(boolean filterAlreadySeen) {
        this.filterAlreadySeen = filterAlreadySeen;
    }

    public boolean isSplitResult() {
        return this.splitResult;
    }

    public void setSplitResult(boolean splitResult) {
        this.splitResult = splitResult;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.serviceUri).append(this.contentType).append(this.httpHeaders).append(this.connectTimeout).append(this.socketTimeout).append(this.proxy).append(this.entityProviderReadProperties).append(this.entityProviderWriteProperties).append(this.filterAlreadySeen).append(this.splitResult).append(this.sslContextParameters).append(this.httpAsyncClientBuilder).append(this.httpClientBuilder).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Olingo2Configuration) {
            Olingo2Configuration other = (Olingo2Configuration)obj;
            return this.connectTimeout == other.connectTimeout && this.filterAlreadySeen == other.filterAlreadySeen && this.splitResult == other.splitResult && this.socketTimeout == other.socketTimeout && this.serviceUri == null ? other.serviceUri == null : (this.serviceUri.equals(other.serviceUri) && this.contentType == null ? other.contentType == null : (this.contentType.equals(other.contentType) && this.httpHeaders == null ? other.httpHeaders == null : (this.httpHeaders.equals(other.httpHeaders) && this.entityProviderReadProperties == null ? other.entityProviderReadProperties == null : (this.entityProviderReadProperties.equals(other.entityProviderReadProperties) && this.proxy == null ? other.proxy == null : (this.proxy.equals(other.proxy) && this.entityProviderWriteProperties == null ? other.entityProviderWriteProperties == null : (this.entityProviderWriteProperties.equals(other.entityProviderWriteProperties) && this.sslContextParameters == null ? other.sslContextParameters == null : (this.sslContextParameters.equals(other.sslContextParameters) && this.httpAsyncClientBuilder == null ? other.httpAsyncClientBuilder == null : (this.httpAsyncClientBuilder.equals(other.httpAsyncClientBuilder) && this.httpClientBuilder == null ? other.httpClientBuilder == null : this.httpClientBuilder.equals(other.httpClientBuilder)))))))));
        }
        return false;
    }
}

