/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch;

import java.util.List;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.batch.BatchHelper;
import org.apache.olingo.odata2.core.commons.ContentType;

public class BatchResponseWriter {
    private static final String COLON = ":";
    private static final String SP = " ";
    private static final String CRLF = "\r\n";
    private final boolean writeEntityAsInputStream;
    private BatchHelper.BodyBuilder writer = new BatchHelper.BodyBuilder();

    public BatchResponseWriter() {
        this(false);
    }

    public BatchResponseWriter(boolean writeEntityAsInputStream) {
        this.writeEntityAsInputStream = writeEntityAsInputStream;
    }

    public ODataResponse writeResponse(List<BatchResponsePart> batchResponseParts) throws BatchException {
        Object batchResponseBody;
        String boundary = BatchHelper.generateBoundary("batch");
        this.appendResponsePart(batchResponseParts, boundary);
        int length = 0;
        if (this.writeEntityAsInputStream) {
            batchResponseBody = this.writer.getContentAsStream();
            length = this.writer.calculateLength(batchResponseBody);
        } else {
            batchResponseBody = this.writer.getContentAsString(BatchHelper.DEFAULT_CHARSET);
            length = this.writer.calculateLength(batchResponseBody);
        }
        return ODataResponse.entity(batchResponseBody).status(HttpStatusCodes.ACCEPTED).header("Content-Type", "multipart/mixed; boundary=" + boundary).header("Content-Length", String.valueOf(length)).build();
    }

    private void appendChangeSet(BatchResponsePart batchResponsePart) throws BatchException {
        String boundary = BatchHelper.generateBoundary("changeset");
        this.writer.append("Content-Type").append(COLON).append(SP).append("multipart/mixed; boundary=" + boundary).append(CRLF).append(CRLF);
        for (ODataResponse response : batchResponsePart.getResponses()) {
            this.writer.append("--").append(boundary).append(CRLF);
            this.appendResponsePartBody(response);
        }
        this.writer.append("--").append(boundary).append("--").append(CRLF);
    }

    private void appendResponsePart(List<BatchResponsePart> batchResponseParts, String boundary) throws BatchException {
        for (BatchResponsePart batchResponsePart : batchResponseParts) {
            this.writer.append("--").append(boundary).append(CRLF);
            if (batchResponsePart.isChangeSet()) {
                this.appendChangeSet(batchResponsePart);
                continue;
            }
            ODataResponse response = batchResponsePart.getResponses().get(0);
            this.appendResponsePartBody(response);
        }
        this.writer.append("--").append(boundary).append("--");
    }

    private void appendResponsePartBody(ODataResponse response) throws BatchException {
        this.writer.append("Content-Type").append(COLON).append(SP).append("application/http").append(CRLF);
        this.writer.append("Content-Transfer-Encoding").append(COLON).append(SP).append("binary").append(CRLF);
        if (response.getHeader("MimeHeader-ContentId") != null) {
            this.writer.append("Content-Id").append(COLON).append(SP).append(response.getHeader("MimeHeader-ContentId")).append(CRLF);
        }
        this.writer.append(CRLF);
        this.writer.append("HTTP/1.1").append(SP).append(String.valueOf(response.getStatus().getStatusCode())).append(SP).append(response.getStatus().getInfo()).append(CRLF);
        if (response.getHeader("Content-Type") != null) {
            BatchHelper.extractCharset(ContentType.parse(response.getHeader("Content-Type")));
        }
        this.appendHeader(response);
        if (!HttpStatusCodes.NO_CONTENT.equals((Object)response.getStatus())) {
            BatchHelper.Body body = new BatchHelper.Body(response);
            this.writer.append("Content-Length").append(COLON).append(SP).append(String.valueOf(body.getLength())).append(CRLF).append(CRLF);
            this.writer.append(body);
        } else {
            this.writer.append(CRLF);
        }
        this.writer.append(CRLF);
    }

    private void appendHeader(ODataResponse response) {
        for (String name : response.getHeaderNames()) {
            if (!"MimeHeader-ContentId".equalsIgnoreCase(name) && !"RequestHeader-ContentId".equalsIgnoreCase(name)) {
                this.writer.append(name).append(COLON).append(SP).append(response.getHeader(name)).append(CRLF);
                continue;
            }
            if (!"RequestHeader-ContentId".equalsIgnoreCase(name)) continue;
            this.writer.append("Content-Id").append(COLON).append(SP).append(response.getHeader(name)).append(CRLF);
        }
    }
}

