/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.EdmByte;
import org.apache.olingo.odata2.core.edm.EdmInt16;
import org.apache.olingo.odata2.core.edm.EdmSByte;
import org.apache.olingo.odata2.core.edm.Uint7;

public class EdmInt32
extends AbstractSimpleType {
    private static final EdmInt32 instance = new EdmInt32();

    public static EdmInt32 getInstance() {
        return instance;
    }

    @Override
    public boolean isCompatible(EdmSimpleType simpleType) {
        return simpleType instanceof Bit || simpleType instanceof Uint7 || simpleType instanceof EdmByte || simpleType instanceof EdmSByte || simpleType instanceof EdmInt16 || simpleType instanceof EdmInt32;
    }

    @Override
    public Class<?> getDefaultType() {
        return Integer.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Integer valueInteger;
        try {
            valueInteger = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
        }
        if (returnType.isAssignableFrom(Integer.class)) {
            return returnType.cast(valueInteger);
        }
        if (returnType.isAssignableFrom(Byte.class)) {
            if (valueInteger >= -128 && valueInteger <= 127) {
                return returnType.cast(valueInteger.byteValue());
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType));
        }
        if (returnType.isAssignableFrom(Short.class)) {
            if (valueInteger >= Short.MIN_VALUE && valueInteger <= Short.MAX_VALUE) {
                return returnType.cast(valueInteger.shortValue());
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType));
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(valueInteger.longValue());
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            if ((Long)value >= Integer.MIN_VALUE && (Long)value <= Integer.MAX_VALUE) {
                return value.toString();
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(value));
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass()));
    }
}

