/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.client.batch.BatchPart;
import org.apache.olingo.odata2.api.client.batch.BatchSingleResponse;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.provider.DataServices;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderBatchProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.exception.ODataNotAcceptableException;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.servicedocument.ServiceDocument;
import org.apache.olingo.odata2.core.batch.BatchRequestWriter;
import org.apache.olingo.odata2.core.batch.BatchResponseWriter;
import org.apache.olingo.odata2.core.batch.v2.BatchParser;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmxProvider;
import org.apache.olingo.odata2.core.ep.AtomEntityProvider;
import org.apache.olingo.odata2.core.ep.BasicEntityProvider;
import org.apache.olingo.odata2.core.ep.ContentTypeBasedEntityProvider;
import org.apache.olingo.odata2.core.ep.JsonEntityProvider;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class ProviderFacadeImpl
implements EntityProvider.EntityProviderInterface {
    private static BasicEntityProvider create() throws EntityProviderException {
        return new BasicEntityProvider();
    }

    private static ContentTypeBasedEntityProvider create(String contentType) throws EntityProviderException {
        return ProviderFacadeImpl.create(ContentType.createAsCustom(contentType));
    }

    private static ContentTypeBasedEntityProvider create(ContentType contentType) throws EntityProviderException {
        try {
            switch (contentType.getODataFormat()) {
                case ATOM: 
                case XML: {
                    return new AtomEntityProvider(contentType.getODataFormat());
                }
                case JSON: {
                    return new JsonEntityProvider();
                }
            }
            throw new ODataNotAcceptableException(ODataNotAcceptableException.NOT_SUPPORTED_CONTENT_TYPE.addContent(contentType));
        }
        catch (ODataNotAcceptableException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    @Override
    public ODataResponse writeErrorDocument(ODataErrorContext context) {
        try {
            return ProviderFacadeImpl.create(context.getContentType()).writeErrorDocument(context);
        }
        catch (EntityProviderException e) {
            throw new ODataRuntimeException(e);
        }
    }

    @Override
    public ODataResponse writeServiceDocument(String contentType, Edm edm, String serviceRoot) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).writeServiceDocument(edm, serviceRoot);
    }

    @Override
    public ODataResponse writePropertyValue(EdmProperty edmProperty, Object value) throws EntityProviderException {
        return ProviderFacadeImpl.create().writePropertyValue(edmProperty, value);
    }

    @Override
    public ODataResponse writeText(String value) throws EntityProviderException {
        return ProviderFacadeImpl.create().writeText(value);
    }

    @Override
    public ODataResponse writeBinary(String mimeType, byte[] data) throws EntityProviderException {
        return ProviderFacadeImpl.create().writeBinary(mimeType, data);
    }

    @Override
    public ODataResponse writeFeed(String contentType, EdmEntitySet entitySet, List<Map<String, Object>> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).writeFeed(entitySet, data, properties);
    }

    @Override
    public ODataResponse writeEntry(String contentType, EdmEntitySet entitySet, Map<String, Object> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).writeEntry(entitySet, data, properties);
    }

    @Override
    public ODataResponse writeProperty(String contentType, EdmProperty edmProperty, Object value) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).writeProperty(edmProperty, value);
    }

    @Override
    public ODataResponse writeLink(String contentType, EdmEntitySet entitySet, Map<String, Object> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).writeLink(entitySet, data, properties);
    }

    @Override
    public ODataResponse writeLinks(String contentType, EdmEntitySet entitySet, List<Map<String, Object>> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).writeLinks(entitySet, data, properties);
    }

    @Override
    public ODataResponse writeFunctionImport(String contentType, EdmFunctionImport functionImport, Object data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).writeFunctionImport(functionImport, data, properties);
    }

    @Override
    public ODataErrorContext readErrorDocument(InputStream errorDocument, String contentType) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readErrorDocument(errorDocument);
    }

    @Override
    public ODataFeed readFeed(String contentType, EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readFeed(entitySet, content, properties);
    }

    @Override
    public ODataDeltaFeed readDeltaFeed(String contentType, EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readDeltaFeed(entitySet, content, properties);
    }

    @Override
    public ODataEntry readEntry(String contentType, EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readEntry(entitySet, content, properties);
    }

    @Override
    public Map<String, Object> readProperty(String contentType, EdmProperty edmProperty, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readProperty(edmProperty, content, properties);
    }

    @Override
    public Object readPropertyValue(EdmProperty edmProperty, InputStream content, Class<?> typeMapping) throws EntityProviderException {
        return ProviderFacadeImpl.create().readPropertyValue(edmProperty, content, typeMapping);
    }

    @Override
    public Object readFunctionImport(String contentType, EdmFunctionImport functionImport, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readFunctionImport(functionImport, content, properties);
    }

    @Override
    public List<String> readLinks(String contentType, EdmEntitySet entitySet, InputStream content) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readLinks(entitySet, content);
    }

    @Override
    public String readLink(String contentType, EdmEntitySet entitySet, InputStream content) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readLink(entitySet, content);
    }

    @Override
    public byte[] readBinary(InputStream content) throws EntityProviderException {
        return ProviderFacadeImpl.create().readBinary(content);
    }

    @Override
    public ODataResponse writeMetadata(List<Schema> schemas, Map<String, String> predefinedNamespaces) throws EntityProviderException {
        return ProviderFacadeImpl.create().writeMetadata(schemas, predefinedNamespaces);
    }

    @Override
    public ODataResponse writeMetadata(DataServices seriviceMetadata, Map<String, String> predefinedNamespaces) throws EntityProviderException {
        return ProviderFacadeImpl.create().writeMetadata(seriviceMetadata, predefinedNamespaces);
    }

    @Override
    public Edm readMetadata(InputStream inputStream, boolean validate) throws EntityProviderException {
        EdmxProvider provider = new EdmxProvider().parse(inputStream, validate);
        return new EdmImplProv(provider);
    }

    @Override
    public ServiceDocument readServiceDocument(InputStream serviceDocument, String contentType) throws EntityProviderException {
        return ProviderFacadeImpl.create(contentType).readServiceDocument(serviceDocument);
    }

    @Override
    public List<BatchRequestPart> parseBatchRequest(String contentType, InputStream content, EntityProviderBatchProperties properties) throws BatchException {
        BatchParser batchParser = new BatchParser(contentType, properties, properties.isStrict());
        List<BatchRequestPart> batchParts = batchParser.parseBatchRequest(content);
        return batchParts;
    }

    @Override
    public ODataResponse writeBatchResponse(List<BatchResponsePart> batchResponseParts) throws BatchException {
        BatchResponseWriter batchWriter = new BatchResponseWriter();
        return batchWriter.writeResponse(batchResponseParts);
    }

    @Override
    public InputStream writeBatchRequest(List<BatchPart> batchParts, String boundary) {
        BatchRequestWriter batchWriter = new BatchRequestWriter();
        return batchWriter.writeBatchRequest(batchParts, boundary);
    }

    @Override
    public List<BatchSingleResponse> parseBatchResponse(String contentType, InputStream content) throws BatchException {
        List<BatchSingleResponse> responses = new BatchParser(contentType, true).parseBatchResponse(content);
        return responses;
    }
}

