/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.streamed;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.ODataPayloadManager;
import org.apache.olingo.client.api.communication.request.ODataStreamedRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.request.Wrapper;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public abstract class AbstractODataStreamedRequest<V extends ODataResponse, T extends ODataPayloadManager<V>>
extends AbstractODataRequest
implements ODataStreamedRequest<V, T> {
    protected ODataPayloadManager<V> payloadManager;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final byte[] CRLF = new byte[]{13, 10};
    protected final Wrapper<Future<HttpResponse>> futureWrapper = new Wrapper();

    public AbstractODataStreamedRequest(ODataClient odataClient, HttpMethod method, URI uri) {
        super(odataClient, method, uri);
        this.setAccept(ContentType.APPLICATION_OCTET_STREAM.toContentTypeString());
        this.setContentType(ContentType.APPLICATION_OCTET_STREAM.toContentTypeString());
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultMediaFormat();
    }

    protected abstract T getPayloadManager();

    @Override
    public T payloadManager() {
        this.payloadManager = this.getPayloadManager();
        if (URIUtils.shouldUseRepeatableHttpBodyEntry(this.odataClient)) {
            this.futureWrapper.setWrapped(this.odataClient.getConfiguration().getExecutor().submit(new Callable<HttpResponse>(){

                @Override
                public HttpResponse call() throws Exception {
                    ((HttpEntityEnclosingRequestBase)AbstractODataStreamedRequest.this.request).setEntity(URIUtils.buildInputStreamEntity(AbstractODataStreamedRequest.this.odataClient, AbstractODataStreamedRequest.this.payloadManager.getBody()));
                    try {
                        HttpResponse httpResponse = AbstractODataStreamedRequest.this.doExecute();
                        return httpResponse;
                    }
                    finally {
                        AbstractODataStreamedRequest.this.payloadManager.finalizeBody();
                    }
                }
            }));
        } else {
            ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, this.payloadManager.getBody()));
            this.futureWrapper.setWrapped(this.odataClient.getConfiguration().getExecutor().submit(new Callable<HttpResponse>(){

                @Override
                public HttpResponse call() throws Exception {
                    try {
                        HttpResponse httpResponse = AbstractODataStreamedRequest.this.doExecute();
                        return httpResponse;
                    }
                    finally {
                        AbstractODataStreamedRequest.this.payloadManager.finalizeBody();
                    }
                }
            }));
        }
        return (T)this.payloadManager;
    }

    public void batch(ODataBatchRequest req) {
        this.batch(req, null);
    }

    public void batch(ODataBatchRequest req, String contentId) {
        InputStream input = this.getPayloadManager().getBody();
        try {
            this.getPayloadManager().finalizeBody();
            req.rawAppend(this.toByteArray());
            if (StringUtils.isNotBlank(contentId)) {
                req.rawAppend(("Content-ID: " + contentId).getBytes(DEFAULT_CHARSET));
                req.rawAppend(CRLF);
            }
            req.rawAppend(CRLF);
            try {
                req.rawAppend(IOUtils.toByteArray(input));
            }
            catch (Exception e) {
                LOG.debug("Invalid stream", (Throwable)e);
                req.rawAppend(new byte[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }
}

