/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.opensearch;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.ClearScrollRequest;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;

public class OpensearchScrollRequestIterator<TDocument>
implements Iterator<Hit<TDocument>>,
Closeable {
    private final SearchRequest searchRequest;
    private final OpenSearchClient esClient;
    private final Class<TDocument> documentClass;
    private Iterator<? extends Hit<TDocument>> currentSearchHits;
    private final int scrollKeepAliveMs;
    private final Exchange exchange;
    private String scrollId;
    private boolean closed;
    private int requestCount;

    public OpensearchScrollRequestIterator(SearchRequest.Builder searchRequestBuilder, OpenSearchClient esClient, int scrollKeepAliveMs, Exchange exchange, Class<TDocument> documentClass) {
        this.searchRequest = searchRequestBuilder.scroll(Time.of(b -> b.time(String.format("%sms", scrollKeepAliveMs)))).build();
        this.esClient = esClient;
        this.scrollKeepAliveMs = scrollKeepAliveMs;
        this.exchange = exchange;
        this.closed = false;
        this.requestCount = 0;
        this.documentClass = documentClass;
        this.setFirstCurrentSearchHits();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean hasNext = this.currentSearchHits.hasNext();
        if (!hasNext) {
            this.updateCurrentSearchHits();
            hasNext = this.currentSearchHits.hasNext();
        }
        return hasNext;
    }

    @Override
    public Hit<TDocument> next() {
        return this.closed ? null : this.currentSearchHits.next();
    }

    private void updateCurrentSearchHits() {
        ScrollResponse<TDocument> scrollResponse = this.scrollSearch();
        this.currentSearchHits = scrollResponse.hits().hits().iterator();
    }

    private void setFirstCurrentSearchHits() {
        SearchResponse<TDocument> searchResponse = this.firstSearch();
        this.currentSearchHits = searchResponse.hits().hits().iterator();
        this.scrollId = searchResponse.scrollId();
    }

    private SearchResponse<TDocument> firstSearch() {
        SearchResponse<TDocument> searchResponse;
        try {
            searchResponse = this.esClient.search(this.searchRequest, this.documentClass);
            ++this.requestCount;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return searchResponse;
    }

    private ScrollResponse<TDocument> scrollSearch() {
        ScrollResponse<TDocument> scrollResponse;
        try {
            ScrollRequest searchScrollRequest = new ScrollRequest.Builder().scroll(Time.of(b -> b.time(String.format("%sms", this.scrollKeepAliveMs)))).scrollId(this.scrollId).build();
            scrollResponse = this.esClient.scroll(searchScrollRequest, this.documentClass);
            ++this.requestCount;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return scrollResponse;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest.Builder().scrollId(List.of(this.scrollId)).build();
                this.esClient.clearScroll(clearScrollRequest);
                this.closed = true;
                this.exchange.setProperty("CamelOpenSearchScrollQueryCount", (Object)this.requestCount);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

