/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.GenericArrayType;
import java.util.List;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;

public abstract class AbstractArrayDeserializer<T>
extends AbstractContainerDeserializer<T>
implements EmbeddedItem {
    private final Class<?> componentClass = this.getRuntimeType() instanceof GenericArrayType ? ReflectionUtils.resolveRawType(this, ((GenericArrayType)this.getRuntimeType()).getGenericComponentType()) : ReflectionUtils.getRawType(this.getRuntimeType()).getComponentType();
    private final ClassModel componentClassModel;

    AbstractArrayDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.componentClassModel = !DefaultSerializers.isKnownType(this.componentClass) ? builder.getJsonbContext().getMappingContext().getOrCreateClassModel(this.componentClass) : null;
    }

    Class<?> getComponentClass() {
        return this.componentClass;
    }

    @Override
    public void appendResult(Object result) {
        this.appendCaptor(this.convertNullToOptionalEmpty(this.componentClass, result));
    }

    private <X> void appendCaptor(X value) {
        this.getItems().add(value);
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        JsonbDeserializer<?> deserializer = ((DeserializerBuilder)((DeserializerBuilder)this.newUnmarshallerItemBuilder(context.getJsonbContext()).withType(this.componentClass)).withCustomization(this.componentClassModel == null ? null : this.componentClassModel.getClassCustomization())).build();
        this.appendResult(deserializer.deserialize(parser, context, this.componentClass));
    }

    protected abstract List<?> getItems();

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveTo(JsonParser.Event.START_ARRAY);
        return parser.getCurrentLevel();
    }
}

