/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import java.lang.reflect.Type;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;

public abstract class AbstractDateTimeDeserializer<T>
extends AbstractValueTypeDeserializer<T> {
    public static final ZoneId UTC = ZoneId.of("UTC");

    public AbstractDateTimeDeserializer(Class<T> clazz, Customization customization) {
        super(clazz, customization);
    }

    @Override
    public T deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        JsonbDateFormatter formatter = this.getJsonbDateFormatter(unmarshaller.getJsonbContext());
        if ("##time-in-millis".equals(formatter.getFormat())) {
            return this.fromInstant(Instant.ofEpochMilli(Long.parseLong(jsonValue)));
        }
        if (formatter.getDateTimeFormatter() != null) {
            return this.parseWithFormatterInternal(jsonValue, formatter.getDateTimeFormatter());
        }
        DateTimeFormatter configDateTimeFormatter = unmarshaller.getJsonbContext().getConfigProperties().getConfigDateFormatter().getDateTimeFormatter();
        if (configDateTimeFormatter != null) {
            return this.parseWithFormatterInternal(jsonValue, configDateTimeFormatter);
        }
        boolean strictIJson = unmarshaller.getJsonbContext().getConfigProperties().isStrictIJson();
        if (strictIJson) {
            return this.parseWithFormatterInternal(jsonValue, JsonbDateFormatter.IJSON_DATE_FORMATTER);
        }
        try {
            return this.parseDefault(jsonValue, unmarshaller.getJsonbContext().getConfigProperties().getLocale(formatter.getLocale()));
        }
        catch (DateTimeException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.DATE_PARSE_ERROR, jsonValue, this.getPropertyType()), e);
        }
    }

    protected JsonbDateFormatter getJsonbDateFormatter(JsonbContext context) {
        if (this.getCustomization() != null && this.getCustomization().getDeserializeDateFormatter() != null) {
            return this.getCustomization().getDeserializeDateFormatter();
        }
        return context.getConfigProperties().getConfigDateFormatter();
    }

    protected DateTimeFormatter getZonedFormatter(DateTimeFormatter formatter) {
        return formatter.getZone() != null ? formatter : formatter.withZone(UTC);
    }

    protected abstract T fromInstant(Instant var1);

    protected abstract T parseDefault(String var1, Locale var2);

    protected abstract T parseWithFormatter(String var1, DateTimeFormatter var2);

    private T parseWithFormatterInternal(String jsonValue, DateTimeFormatter formatter) {
        try {
            return this.parseWithFormatter(jsonValue, formatter);
        }
        catch (DateTimeException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.DATE_PARSE_ERROR, jsonValue, this.getPropertyType()), e);
        }
    }
}

