/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.MetricAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class CardinalityAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer precisionThreshold;
    @Nullable
    private final Boolean rehash;
    public static final JsonpDeserializer<CardinalityAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CardinalityAggregation::setupCardinalityAggregationDeserializer);

    private CardinalityAggregation(Builder builder) {
        super(builder);
        this.precisionThreshold = builder.precisionThreshold;
        this.rehash = builder.rehash;
    }

    public static CardinalityAggregation of(Function<Builder, ObjectBuilder<CardinalityAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Cardinality;
    }

    @Nullable
    public final Integer precisionThreshold() {
        return this.precisionThreshold;
    }

    @Nullable
    public final Boolean rehash() {
        return this.rehash;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.precisionThreshold != null) {
            generator.writeKey("precision_threshold");
            generator.write(this.precisionThreshold);
        }
        if (this.rehash != null) {
            generator.writeKey("rehash");
            generator.write(this.rehash);
        }
    }

    protected static void setupCardinalityAggregationDeserializer(ObjectDeserializer<Builder> op) {
        CardinalityAggregation.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::precisionThreshold, JsonpDeserializer.integerDeserializer(), "precision_threshold");
        op.add(Builder::rehash, JsonpDeserializer.booleanDeserializer(), "rehash");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CardinalityAggregation> {
        @Nullable
        private Integer precisionThreshold;
        @Nullable
        private Boolean rehash;

        public final Builder precisionThreshold(@Nullable Integer value) {
            this.precisionThreshold = value;
            return this;
        }

        public final Builder rehash(@Nullable Boolean value) {
            this.rehash = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CardinalityAggregation build() {
            this._checkSingleUse();
            return new CardinalityAggregation(this);
        }
    }
}

