/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class DiskUsage
implements PlainJsonSerializable {
    private final String path;
    private final long totalBytes;
    private final long usedBytes;
    private final long freeBytes;
    private final double freeDiskPercent;
    private final double usedDiskPercent;
    public static final JsonpDeserializer<DiskUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiskUsage::setupDiskUsageDeserializer);

    private DiskUsage(Builder builder) {
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.totalBytes = ApiTypeHelper.requireNonNull(builder.totalBytes, this, "totalBytes");
        this.usedBytes = ApiTypeHelper.requireNonNull(builder.usedBytes, this, "usedBytes");
        this.freeBytes = ApiTypeHelper.requireNonNull(builder.freeBytes, this, "freeBytes");
        this.freeDiskPercent = ApiTypeHelper.requireNonNull(builder.freeDiskPercent, this, "freeDiskPercent");
        this.usedDiskPercent = ApiTypeHelper.requireNonNull(builder.usedDiskPercent, this, "usedDiskPercent");
    }

    public static DiskUsage of(Function<Builder, ObjectBuilder<DiskUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String path() {
        return this.path;
    }

    public final long totalBytes() {
        return this.totalBytes;
    }

    public final long usedBytes() {
        return this.usedBytes;
    }

    public final long freeBytes() {
        return this.freeBytes;
    }

    public final double freeDiskPercent() {
        return this.freeDiskPercent;
    }

    public final double usedDiskPercent() {
        return this.usedDiskPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("total_bytes");
        generator.write(this.totalBytes);
        generator.writeKey("used_bytes");
        generator.write(this.usedBytes);
        generator.writeKey("free_bytes");
        generator.write(this.freeBytes);
        generator.writeKey("free_disk_percent");
        generator.write(this.freeDiskPercent);
        generator.writeKey("used_disk_percent");
        generator.write(this.usedDiskPercent);
    }

    protected static void setupDiskUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::totalBytes, JsonpDeserializer.longDeserializer(), "total_bytes");
        op.add(Builder::usedBytes, JsonpDeserializer.longDeserializer(), "used_bytes");
        op.add(Builder::freeBytes, JsonpDeserializer.longDeserializer(), "free_bytes");
        op.add(Builder::freeDiskPercent, JsonpDeserializer.doubleDeserializer(), "free_disk_percent");
        op.add(Builder::usedDiskPercent, JsonpDeserializer.doubleDeserializer(), "used_disk_percent");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DiskUsage> {
        private String path;
        private Long totalBytes;
        private Long usedBytes;
        private Long freeBytes;
        private Double freeDiskPercent;
        private Double usedDiskPercent;

        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        public final Builder totalBytes(long value) {
            this.totalBytes = value;
            return this;
        }

        public final Builder usedBytes(long value) {
            this.usedBytes = value;
            return this;
        }

        public final Builder freeBytes(long value) {
            this.freeBytes = value;
            return this;
        }

        public final Builder freeDiskPercent(double value) {
            this.freeDiskPercent = value;
            return this;
        }

        public final Builder usedDiskPercent(double value) {
            this.usedDiskPercent = value;
            return this;
        }

        @Override
        public DiskUsage build() {
            this._checkSingleUse();
            return new DiskUsage(this);
        }
    }
}

