/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.msearch;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ScriptField;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.FieldAndFormat;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.search.FieldCollapse;
import org.opensearch.client.opensearch.core.search.Highlight;
import org.opensearch.client.opensearch.core.search.Rescore;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.core.search.Suggester;
import org.opensearch.client.opensearch.core.search.TrackHits;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class MultisearchBody
implements PlainJsonSerializable {
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final Query query;
    @Nullable
    private final Integer from;
    @Nullable
    private final Double minScore;
    @Nullable
    private final Query postFilter;
    private final List<String> searchAfter;
    @Nullable
    private final Integer size;
    private final List<SortOptions> sort;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final TrackHits trackTotalHits;
    @Nullable
    private final Suggester suggest;
    @Nullable
    private Highlight highlight;
    @Nullable
    private SourceConfig source;
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final Boolean seqNoPrimaryTerm;
    private final List<String> storedFields;
    @Nullable
    private final Boolean explain;
    private final List<FieldAndFormat> fields;
    private final List<Map<String, Double>> indicesBoost;
    @Nullable
    private final FieldCollapse collapse;
    @Nullable
    private final Boolean version;
    @Nullable
    private final String timeout;
    private final List<Rescore> rescore;
    private final Map<String, JsonData> ext;
    public static final JsonpDeserializer<MultisearchBody> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultisearchBody::setupMultisearchBodyDeserializer);

    private MultisearchBody(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.query = builder.query;
        this.from = builder.from;
        this.minScore = builder.minScore;
        this.postFilter = builder.postFilter;
        this.searchAfter = ApiTypeHelper.unmodifiable(builder.searchAfter);
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.trackScores = builder.trackScores;
        this.trackTotalHits = builder.trackTotalHits;
        this.suggest = builder.suggest;
        this.highlight = builder.highlight;
        this.source = builder.source;
        this.scriptFields = ApiTypeHelper.unmodifiable(builder.scriptFields);
        this.seqNoPrimaryTerm = builder.seqNoPrimaryTerm;
        this.storedFields = ApiTypeHelper.unmodifiable(builder.storedFields);
        this.explain = builder.explain;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.indicesBoost = ApiTypeHelper.unmodifiable(builder.indicesBoost);
        this.collapse = builder.collapse;
        this.version = builder.version;
        this.timeout = builder.timeout;
        this.rescore = ApiTypeHelper.unmodifiable(builder.rescore);
        this.ext = ApiTypeHelper.unmodifiable(builder.ext);
    }

    public static MultisearchBody of(Function<Builder, ObjectBuilder<MultisearchBody>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Double minScore() {
        return this.minScore;
    }

    @Nullable
    public final Query postFilter() {
        return this.postFilter;
    }

    public final List<String> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Nullable
    public final Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public final TrackHits trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public final Suggester suggest() {
        return this.suggest;
    }

    @Nullable
    public final Highlight highlight() {
        return this.highlight;
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    public final Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public final Boolean seqNoPrimaryTerm() {
        return this.seqNoPrimaryTerm;
    }

    public final List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    public final List<FieldAndFormat> fields() {
        return this.fields;
    }

    public final List<Map<String, Double>> indicesBoost() {
        return this.indicesBoost;
    }

    @Nullable
    public final FieldCollapse collapse() {
        return this.collapse;
    }

    @Nullable
    public final Boolean version() {
        return this.version;
    }

    @Nullable
    public final String timeout() {
        return this.timeout;
    }

    public final List<Rescore> rescore() {
        return this.rescore;
    }

    public final Map<String, JsonData> ext() {
        return this.ext;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from);
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore);
        }
        if (this.postFilter != null) {
            generator.writeKey("post_filter");
            this.postFilter.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.searchAfter)) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (String string : this.searchAfter) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.trackScores != null) {
            generator.writeKey("track_scores");
            generator.write(this.trackScores);
        }
        if (this.trackTotalHits != null) {
            generator.writeKey("track_total_hits");
            this.trackTotalHits.serialize(generator, mapper);
        }
        if (this.suggest != null) {
            generator.writeKey("suggest");
            this.suggest.serialize(generator, mapper);
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.scriptFields)) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.seqNoPrimaryTerm != null) {
            generator.writeKey("seq_no_primary_term");
            generator.write(this.seqNoPrimaryTerm);
        }
        if (ApiTypeHelper.isDefined(this.storedFields)) {
            generator.writeKey("stored_fields");
            generator.writeStartArray();
            for (String string : this.storedFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (FieldAndFormat fieldAndFormat : this.fields) {
                fieldAndFormat.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indicesBoost)) {
            generator.writeKey("indices_boost");
            generator.writeStartArray();
            for (Map map : this.indicesBoost) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        generator.write((Double)item1.getValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.collapse != null) {
            generator.writeKey("collapse");
            this.collapse.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
        if (ApiTypeHelper.isDefined(this.rescore)) {
            generator.writeKey("rescore");
            generator.writeStartArray();
            for (Rescore rescore : this.rescore) {
                rescore.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ext)) {
            generator.writeKey("ext");
            generator.writeStartObject();
            for (Map.Entry entry : this.ext.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMultisearchBodyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score");
        op.add(Builder::postFilter, Query._DESERIALIZER, "post_filter");
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "search_after");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
        op.add(Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores");
        op.add(Builder::trackTotalHits, TrackHits._DESERIALIZER, "track_total_hits");
        op.add(Builder::suggest, Suggester._DESERIALIZER, "suggest");
        op.add(Builder::highlight, Highlight._DESERIALIZER, "highlight");
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields");
        op.add(Builder::seqNoPrimaryTerm, JsonpDeserializer.booleanDeserializer(), "seq_no_primary_term");
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields");
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(FieldAndFormat._DESERIALIZER), "fields");
        op.add(Builder::indicesBoost, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer())), "indices_boost");
        op.add(Builder::collapse, FieldCollapse._DESERIALIZER, "collapse");
        op.add(Builder::version, JsonpDeserializer.booleanDeserializer(), "version");
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout");
        op.add(Builder::rescore, JsonpDeserializer.arrayDeserializer(Rescore._DESERIALIZER), "rescore");
        op.add(Builder::ext, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "ext");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MultisearchBody> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Query query;
        @Nullable
        private Integer from;
        @Nullable
        private Double minScore;
        @Nullable
        private Query postFilter;
        @Nullable
        private List<String> searchAfter;
        @Nullable
        private Integer size;
        @Nullable
        private List<SortOptions> sort;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private TrackHits trackTotalHits;
        @Nullable
        private Suggester suggest;
        @Nullable
        private Highlight highlight;
        @Nullable
        private SourceConfig source;
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private Boolean seqNoPrimaryTerm;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private Boolean explain;
        @Nullable
        private List<FieldAndFormat> fields;
        @Nullable
        private List<Map<String, Double>> indicesBoost;
        @Nullable
        private FieldCollapse collapse;
        @Nullable
        private Boolean version;
        @Nullable
        private String timeout;
        @Nullable
        private List<Rescore> rescore;
        @Nullable
        private Map<String, JsonData> ext;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public final Builder postFilter(@Nullable Query value) {
            this.postFilter = value;
            return this;
        }

        public final Builder postFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.postFilter(fn.apply(new Query.Builder()).build());
        }

        public final Builder searchAfter(List<String> list) {
            this.searchAfter = Builder._listAddAll(this.searchAfter, list);
            return this;
        }

        public final Builder searchAfter(String value, String ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        public final Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        public final Builder trackTotalHits(@Nullable TrackHits value) {
            this.trackTotalHits = value;
            return this;
        }

        public final Builder trackTotalHits(Function<TrackHits.Builder, ObjectBuilder<TrackHits>> fn) {
            return this.trackTotalHits(fn.apply(new TrackHits.Builder()).build());
        }

        public final Builder suggest(@Nullable Suggester value) {
            this.suggest = value;
            return this;
        }

        public final Builder suggest(Function<Suggester.Builder, ObjectBuilder<Suggester>> fn) {
            return this.suggest(fn.apply(new Suggester.Builder()).build());
        }

        public final Builder highlight(@Nullable Highlight value) {
            this.highlight = value;
            return this;
        }

        public final Builder highlight(Function<Highlight.Builder, ObjectBuilder<Highlight>> fn) {
            return this.highlight(fn.apply(new Highlight.Builder()).build());
        }

        public final Builder source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder scriptFields(Map<String, ScriptField> map) {
            this.scriptFields = Builder._mapPutAll(this.scriptFields, map);
            return this;
        }

        public final Builder scriptFields(String key, ScriptField value) {
            this.scriptFields = Builder._mapPut(this.scriptFields, key, value);
            return this;
        }

        public final Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public final Builder seqNoPrimaryTerm(@Nullable Boolean value) {
            this.seqNoPrimaryTerm = value;
            return this;
        }

        public final Builder storedFields(List<String> list) {
            this.storedFields = Builder._listAddAll(this.storedFields, list);
            return this;
        }

        public final Builder storedFields(String value, String ... values) {
            this.storedFields = Builder._listAdd(this.storedFields, value, values);
            return this;
        }

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder fields(List<FieldAndFormat> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(FieldAndFormat value, FieldAndFormat ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.fields(fn.apply(new FieldAndFormat.Builder()).build(), new FieldAndFormat[0]);
        }

        public final Builder indicesBoost(List<Map<String, Double>> list) {
            this.indicesBoost = Builder._listAddAll(this.indicesBoost, list);
            return this;
        }

        public final Builder indicesBoost(Map<String, Double> value, Map<String, Double> ... values) {
            this.indicesBoost = Builder._listAdd(this.indicesBoost, value, values);
            return this;
        }

        public final Builder collapse(@Nullable FieldCollapse value) {
            this.collapse = value;
            return this;
        }

        public final Builder collapse(Function<FieldCollapse.Builder, ObjectBuilder<FieldCollapse>> fn) {
            return this.collapse(fn.apply(new FieldCollapse.Builder()).build());
        }

        public final Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        public final Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public final Builder rescore(List<Rescore> list) {
            this.rescore = Builder._listAddAll(this.rescore, list);
            return this;
        }

        public final Builder rescore(Rescore value, Rescore ... values) {
            this.rescore = Builder._listAdd(this.rescore, value, values);
            return this;
        }

        public final Builder rescore(Function<Rescore.Builder, ObjectBuilder<Rescore>> fn) {
            return this.rescore(fn.apply(new Rescore.Builder()).build(), new Rescore[0]);
        }

        public final Builder ext(Map<String, JsonData> map) {
            this.ext = Builder._mapPutAll(this.ext, map);
            return this;
        }

        public final Builder ext(String key, JsonData value) {
            this.ext = Builder._mapPut(this.ext, key, value);
            return this;
        }

        @Override
        public MultisearchBody build() {
            this._checkSingleUse();
            return new MultisearchBody(this);
        }
    }
}

