/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.termvectors;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.termvectors.Token;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Term
implements PlainJsonSerializable {
    @Nullable
    private final Integer docFreq;
    @Nullable
    private final Double score;
    private final Integer termFreq;
    private final List<Token> tokens;
    @Nullable
    private final Integer ttf;
    public static final JsonpDeserializer<Term> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Term::setupTermDeserializer);

    private Term(Builder builder) {
        this.docFreq = builder.docFreq;
        this.score = builder.score;
        this.termFreq = builder.termFreq;
        this.tokens = ApiTypeHelper.unmodifiable(builder.tokens);
        this.ttf = builder.ttf;
    }

    public static Term of(Function<Builder, ObjectBuilder<Term>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer docFreq() {
        return this.docFreq;
    }

    @Nullable
    public final Double score() {
        return this.score;
    }

    public final int termFreq() {
        return this.termFreq;
    }

    public final List<Token> tokens() {
        return this.tokens;
    }

    @Nullable
    public final Integer ttf() {
        return this.ttf;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.docFreq != null) {
            generator.writeKey("doc_freq");
            generator.write(this.docFreq);
        }
        if (this.score != null) {
            generator.writeKey("score");
            generator.write(this.score);
        }
        if (null != this.termFreq) {
            generator.writeKey("term_freq");
            generator.write(this.termFreq);
        }
        if (ApiTypeHelper.isDefined(this.tokens)) {
            generator.writeKey("tokens");
            generator.writeStartArray();
            for (Token item0 : this.tokens) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ttf != null) {
            generator.writeKey("ttf");
            generator.write(this.ttf);
        }
    }

    protected static void setupTermDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docFreq, JsonpDeserializer.integerDeserializer(), "doc_freq");
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "score");
        op.add(Builder::termFreq, JsonpDeserializer.integerDeserializer(), "term_freq");
        op.add(Builder::tokens, JsonpDeserializer.arrayDeserializer(Token._DESERIALIZER), "tokens");
        op.add(Builder::ttf, JsonpDeserializer.integerDeserializer(), "ttf");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Term> {
        @Nullable
        private Integer docFreq;
        @Nullable
        private Double score;
        private Integer termFreq;
        private List<Token> tokens;
        @Nullable
        private Integer ttf;

        public final Builder docFreq(@Nullable Integer value) {
            this.docFreq = value;
            return this;
        }

        public final Builder score(@Nullable Double value) {
            this.score = value;
            return this;
        }

        public final Builder termFreq(int value) {
            this.termFreq = value;
            return this;
        }

        public final Builder tokens(List<Token> list) {
            this.tokens = Builder._listAddAll(this.tokens, list);
            return this;
        }

        public final Builder tokens(Token value, Token ... values) {
            this.tokens = Builder._listAdd(this.tokens, value, values);
            return this;
        }

        public final Builder tokens(Function<Token.Builder, ObjectBuilder<Token>> fn) {
            return this.tokens(fn.apply(new Token.Builder()).build(), new Token[0]);
        }

        public final Builder ttf(@Nullable Integer value) {
            this.ttf = value;
            return this;
        }

        @Override
        public Term build() {
            this._checkSingleUse();
            return new Term(this);
        }
    }
}

