/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IndexDetails
implements PlainJsonSerializable {
    private final int shardCount;
    @Nullable
    private final String size;
    private final long sizeInBytes;
    private final long maxSegmentsPerShard;
    public static final JsonpDeserializer<IndexDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexDetails::setupIndexDetailsDeserializer);

    private IndexDetails(Builder builder) {
        this.shardCount = ApiTypeHelper.requireNonNull(builder.shardCount, this, "shardCount");
        this.size = builder.size;
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, this, "sizeInBytes");
        this.maxSegmentsPerShard = ApiTypeHelper.requireNonNull(builder.maxSegmentsPerShard, this, "maxSegmentsPerShard");
    }

    public static IndexDetails of(Function<Builder, ObjectBuilder<IndexDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int shardCount() {
        return this.shardCount;
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    public final long maxSegmentsPerShard() {
        return this.maxSegmentsPerShard;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("shard_count");
        generator.write(this.shardCount);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        generator.writeKey("max_segments_per_shard");
        generator.write(this.maxSegmentsPerShard);
    }

    protected static void setupIndexDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shardCount, JsonpDeserializer.integerDeserializer(), "shard_count");
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
        op.add(Builder::maxSegmentsPerShard, JsonpDeserializer.longDeserializer(), "max_segments_per_shard");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexDetails> {
        private Integer shardCount;
        @Nullable
        private String size;
        private Long sizeInBytes;
        private Long maxSegmentsPerShard;

        public final Builder shardCount(int value) {
            this.shardCount = value;
            return this;
        }

        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        public final Builder maxSegmentsPerShard(long value) {
            this.maxSegmentsPerShard = value;
            return this;
        }

        @Override
        public IndexDetails build() {
            this._checkSingleUse();
            return new IndexDetails(this);
        }
    }
}

