/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.tasks.Status;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Info
implements PlainJsonSerializable {
    private final String action;
    private final boolean cancellable;
    private final List<Info> children;
    @Nullable
    private final String description;
    private final Map<String, List<String>> headers;
    private final long id;
    private final String node;
    private final long runningTimeInNanos;
    private final long startTimeInMillis;
    @Nullable
    private final Status status;
    private final String type;
    @Nullable
    private final String parentTaskId;
    public static final JsonpDeserializer<Info> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Info::setupInfoDeserializer);

    private Info(Builder builder) {
        this.action = ApiTypeHelper.requireNonNull(builder.action, this, "action");
        this.cancellable = ApiTypeHelper.requireNonNull(builder.cancellable, this, "cancellable");
        this.children = ApiTypeHelper.unmodifiable(builder.children);
        this.description = builder.description;
        this.headers = ApiTypeHelper.unmodifiableRequired(builder.headers, (Object)this, "headers");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.runningTimeInNanos = ApiTypeHelper.requireNonNull(builder.runningTimeInNanos, this, "runningTimeInNanos");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, this, "startTimeInMillis");
        this.status = builder.status;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.parentTaskId = builder.parentTaskId;
    }

    public static Info of(Function<Builder, ObjectBuilder<Info>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String action() {
        return this.action;
    }

    public final boolean cancellable() {
        return this.cancellable;
    }

    public final List<Info> children() {
        return this.children;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final Map<String, List<String>> headers() {
        return this.headers;
    }

    public final long id() {
        return this.id;
    }

    public final String node() {
        return this.node;
    }

    public final long runningTimeInNanos() {
        return this.runningTimeInNanos;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final Status status() {
        return this.status;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final String parentTaskId() {
        return this.parentTaskId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("cancellable");
        generator.write(this.cancellable);
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (Info info : this.children) {
                info.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry entry : this.headers.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("running_time_in_nanos");
        generator.write(this.runningTimeInNanos);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        generator.writeKey("type");
        generator.write(this.type);
        if (this.parentTaskId != null) {
            generator.writeKey("parent_task_id");
            generator.write(this.parentTaskId);
        }
    }

    protected static void setupInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action");
        op.add(Builder::cancellable, JsonpDeserializer.booleanDeserializer(), "cancellable");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "headers");
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::runningTimeInNanos, JsonpDeserializer.longDeserializer(), "running_time_in_nanos");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::status, Status._DESERIALIZER, "status");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::parentTaskId, JsonpDeserializer.stringDeserializer(), "parent_task_id");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Info> {
        private String action;
        private Boolean cancellable;
        @Nullable
        private List<Info> children;
        @Nullable
        private String description;
        private Map<String, List<String>> headers;
        private Long id;
        private String node;
        private Long runningTimeInNanos;
        private Long startTimeInMillis;
        @Nullable
        private Status status;
        private String type;
        @Nullable
        private String parentTaskId;

        public final Builder action(String value) {
            this.action = value;
            return this;
        }

        public final Builder cancellable(boolean value) {
            this.cancellable = value;
            return this;
        }

        public final Builder children(List<Info> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        public final Builder children(Info value, Info ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        public final Builder children(Function<Builder, ObjectBuilder<Info>> fn) {
            return this.children(fn.apply(new Builder()).build(), new Info[0]);
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder headers(Map<String, List<String>> map) {
            this.headers = Builder._mapPutAll(this.headers, map);
            return this;
        }

        public final Builder headers(String key, List<String> value) {
            this.headers = Builder._mapPut(this.headers, key, value);
            return this;
        }

        public final Builder id(long value) {
            this.id = value;
            return this;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder runningTimeInNanos(long value) {
            this.runningTimeInNanos = value;
            return this;
        }

        public final Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder status(@Nullable Status value) {
            this.status = value;
            return this;
        }

        public final Builder status(Function<Status.Builder, ObjectBuilder<Status>> fn) {
            return this.status(fn.apply(new Status.Builder()).build());
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this;
        }

        @Override
        public Info build() {
            this._checkSingleUse();
            return new Info(this);
        }
    }
}

