/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.opensearch.converter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch._types.WaitForActiveShards;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.MgetRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.BulkOperationVariant;
import org.opensearch.client.opensearch.core.bulk.CreateOperation;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.opensearch.indices.DeleteIndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class OpensearchActionRequestConverter {
    private static final Logger LOG = LoggerFactory.getLogger(OpensearchActionRequestConverter.class);
    private static final String OPENSEARCH_QUERY_DSL_PREFIX = "query";
    private static final String OPENSEARCH_UPDATE_DOC_PREFIX = "doc";

    private OpensearchActionRequestConverter() {
    }

    private static IndexOperation.Builder<?> createIndexOperationBuilder(Object document, Exchange exchange) throws IOException {
        if (document instanceof IndexOperation.Builder) {
            return (IndexOperation.Builder)document;
        }
        JacksonJsonpMapper mapper = OpensearchActionRequestConverter.createMapper();
        IndexOperation.Builder<Object> builder = new IndexOperation.Builder<Object>();
        if (document instanceof byte[]) {
            byte[] byteArray = (byte[])document;
            builder.document(JsonData.of(mapper.objectMapper().reader().readTree(byteArray), mapper).toJson());
        } else if (document instanceof InputStream) {
            InputStream inputStream = (InputStream)document;
            builder.document(JsonData.of(mapper.objectMapper().reader().readTree(inputStream), mapper).toJson());
        } else if (document instanceof String) {
            String string = (String)document;
            builder.document(JsonData.of(mapper.objectMapper().reader().readTree(new StringReader(string)), mapper).toJson());
        } else if (document instanceof Reader) {
            Reader reader = (Reader)document;
            builder.document(JsonData.of(mapper.objectMapper().reader().readTree(reader), mapper).toJson());
        } else {
            builder.document(document);
        }
        return (IndexOperation.Builder)builder.index(exchange.getIn().getHeader("indexName", String.class));
    }

    @Converter
    public static IndexRequest.Builder<?> toIndexRequestBuilder(Object document, Exchange exchange) throws IOException {
        if (document instanceof IndexRequest.Builder) {
            IndexRequest.Builder builder = (IndexRequest.Builder)document;
            return builder.id(exchange.getIn().getHeader("indexId", String.class));
        }
        JacksonJsonpMapper mapper = OpensearchActionRequestConverter.createMapper();
        IndexRequest.Builder<Object> builder = new IndexRequest.Builder<Object>();
        if (document instanceof byte[]) {
            byte[] byteArray = (byte[])document;
            builder.document(JsonData.of(mapper.objectMapper().reader().readTree(byteArray), mapper).toJson());
        } else if (document instanceof InputStream) {
            InputStream inputStream = (InputStream)document;
            builder.document(JsonData.of(mapper.objectMapper().reader().readTree(inputStream), mapper).toJson());
        } else if (document instanceof String) {
            String string = (String)document;
            builder.document(JsonData.of(mapper.objectMapper().reader().readTree(new StringReader(string)), mapper).toJson());
        } else if (document instanceof Reader) {
            Reader reader = (Reader)document;
            builder.document(JsonData.of(mapper.objectMapper().reader().readTree(reader), mapper).toJson());
        } else {
            builder.document(document);
        }
        return builder.waitForActiveShards(new WaitForActiveShards.Builder().count(exchange.getIn().getHeader("waitForActiveShards", Integer.class)).build()).id(exchange.getIn().getHeader("indexId", String.class)).index(exchange.getIn().getHeader("indexName", String.class));
    }

    @Converter
    public static UpdateRequest.Builder<?, ?> toUpdateRequestBuilder(Object document, Exchange exchange) throws IOException {
        if (document instanceof UpdateRequest.Builder) {
            UpdateRequest.Builder builder = (UpdateRequest.Builder)document;
            return builder.id(exchange.getIn().getHeader("indexId", String.class));
        }
        JacksonJsonpMapper mapper = OpensearchActionRequestConverter.createMapper();
        UpdateRequest.Builder builder = new UpdateRequest.Builder();
        if (document instanceof byte[]) {
            byte[] byteArray = (byte[])document;
            document = JsonData.of(mapper.objectMapper().reader().readTree(byteArray), mapper).to(JsonNode.class);
        } else if (document instanceof InputStream) {
            InputStream inputStream = (InputStream)document;
            document = JsonData.of(mapper.objectMapper().reader().readTree(inputStream), mapper).to(JsonNode.class);
        } else if (document instanceof String) {
            String string = (String)document;
            document = JsonData.of(mapper.objectMapper().reader().readTree(new StringReader(string)), mapper).to(JsonNode.class);
        } else if (document instanceof Reader) {
            Reader reader = (Reader)document;
            document = JsonData.of(mapper.objectMapper().reader().readTree(reader), mapper).to(JsonNode.class);
        } else if (document instanceof Map) {
            Map map = (Map)document;
            document = mapper.objectMapper().convertValue((Object)map, JsonNode.class);
        }
        if (document instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)document;
            JsonNode parentJsonNode = jsonNode.get(OPENSEARCH_UPDATE_DOC_PREFIX);
            if (parentJsonNode != null) {
                document = parentJsonNode;
            }
            document = JsonData.of(document, mapper).toJson();
        }
        return builder.doc(document).waitForActiveShards(new WaitForActiveShards.Builder().count(exchange.getIn().getHeader("waitForActiveShards", Integer.class)).build()).index(exchange.getIn().getHeader("indexName", String.class)).id(exchange.getIn().getHeader("indexId", String.class));
    }

    @Converter
    public static GetRequest.Builder toGetRequestBuilder(Object document, Exchange exchange) {
        if (document instanceof GetRequest.Builder) {
            return (GetRequest.Builder)document;
        }
        if (document instanceof String) {
            return new GetRequest.Builder().index(exchange.getIn().getHeader("indexName", String.class)).id((String)document);
        }
        return null;
    }

    @Converter
    public static DeleteRequest.Builder toDeleteRequestBuilder(Object document, Exchange exchange) {
        if (document instanceof DeleteRequest.Builder) {
            return (DeleteRequest.Builder)document;
        }
        if (document instanceof String) {
            return new DeleteRequest.Builder().index(exchange.getIn().getHeader("indexName", String.class)).id((String)document);
        }
        return null;
    }

    @Converter
    public static DeleteIndexRequest.Builder toDeleteIndexRequestBuilder(Object document, Exchange exchange) {
        if (document instanceof DeleteIndexRequest.Builder) {
            return (DeleteIndexRequest.Builder)document;
        }
        if (document instanceof String) {
            return new DeleteIndexRequest.Builder().index(exchange.getIn().getHeader("indexName", String.class), new String[0]);
        }
        return null;
    }

    @Converter
    public static MgetRequest.Builder toMgetRequestBuilder(Object documents, Exchange exchange) {
        if (documents instanceof MgetRequest.Builder) {
            return (MgetRequest.Builder)documents;
        }
        if (documents instanceof Iterable) {
            Iterable documentIterable = (Iterable)documents;
            MgetRequest.Builder builder = new MgetRequest.Builder();
            builder.index(exchange.getIn().getHeader("indexName", String.class));
            for (Object document : documentIterable) {
                if (document instanceof String) {
                    builder.ids((String)document, new String[0]);
                    continue;
                }
                LOG.warn("Cannot convert document id of type {} into a String", (Object)(document == null ? "null" : document.getClass().getName()));
                return null;
            }
            return builder;
        }
        return null;
    }

    @Converter
    public static SearchRequest.Builder toSearchRequestBuilder(Object queryObject, Exchange exchange) throws IOException {
        String indexName = exchange.getIn().getHeader("indexName", String.class);
        if (queryObject instanceof SearchRequest.Builder) {
            SearchRequest.Builder builder = (SearchRequest.Builder)queryObject;
            if (builder.build().index().isEmpty()) {
                builder.index(indexName, new String[0]);
            }
            return builder;
        }
        SearchRequest.Builder builder = new SearchRequest.Builder();
        Integer size = exchange.getIn().getHeader("size", Integer.class);
        Integer from = exchange.getIn().getHeader("from", Integer.class);
        if (ObjectHelper.isNotEmpty(indexName)) {
            builder.index(indexName, new String[0]);
        }
        if (queryObject instanceof Map) {
            Map mapQuery = (Map)queryObject;
            if (mapQuery.containsKey(OPENSEARCH_QUERY_DSL_PREFIX)) {
                mapQuery = (Map)mapQuery.get(OPENSEARCH_QUERY_DSL_PREFIX);
            }
            queryObject = mapQuery;
        } else if (queryObject instanceof String) {
            String queryString = (String)queryObject;
            JacksonJsonpMapper mapper = OpensearchActionRequestConverter.createMapper();
            JsonNode jsonTextObject = mapper.objectMapper().readValue(queryString, JsonNode.class);
            JsonNode parentJsonNode = jsonTextObject.get(OPENSEARCH_QUERY_DSL_PREFIX);
            if (parentJsonNode != null) {
                queryString = parentJsonNode.toString();
            }
            mapper.objectMapper().reader().readTree(new StringReader(queryString));
            queryObject = JsonData.of(mapper.objectMapper().reader().readTree(new StringReader(queryString)), mapper).toJson();
        } else {
            LOG.warn("Cannot convert queryObject of type {} into SearchRequest object", (Object)(queryObject == null ? "null" : queryObject.getClass().getName()));
            return null;
        }
        if (size != null) {
            builder.size(size);
        }
        if (from != null) {
            builder.from(from);
        }
        builder.query(JsonData.of(queryObject, OpensearchActionRequestConverter.createMapper()).to(Query.class));
        return builder;
    }

    @Converter
    public static BulkRequest.Builder toBulkRequestBuilder(Object documents, Exchange exchange) throws IOException {
        if (documents instanceof BulkRequest.Builder) {
            return (BulkRequest.Builder)documents;
        }
        if (documents instanceof Iterable) {
            BulkRequest.Builder builder = new BulkRequest.Builder();
            builder.index(exchange.getIn().getHeader("indexName", String.class));
            for (Object document : (List)documents) {
                if (document instanceof BulkOperationVariant) {
                    builder.operations(((BulkOperationVariant)document)._toBulkOperation(), new BulkOperation[0]);
                    continue;
                }
                if (document instanceof DeleteOperation.Builder) {
                    builder.operations(new BulkOperation.Builder().delete(((DeleteOperation.Builder)document).build()).build(), new BulkOperation[0]);
                    continue;
                }
                if (document instanceof UpdateOperation.Builder) {
                    builder.operations(new BulkOperation.Builder().update(((UpdateOperation.Builder)document).build()).build(), new BulkOperation[0]);
                    continue;
                }
                if (document instanceof CreateOperation.Builder) {
                    builder.operations(new BulkOperation.Builder().create(((CreateOperation.Builder)document).build()).build(), new BulkOperation[0]);
                    continue;
                }
                builder.operations(new BulkOperation.Builder().index(OpensearchActionRequestConverter.createIndexOperationBuilder(document, exchange).build()).build(), new BulkOperation[0]);
            }
            return builder;
        }
        return null;
    }

    private static JacksonJsonpMapper createMapper() {
        ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return new JacksonJsonpMapper(objectMapper);
    }
}

