/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.CreatorModel;
import org.eclipse.yasson.internal.model.JsonbCreator;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;

class ObjectDeserializer<T>
extends AbstractContainerDeserializer<T> {
    private Map<String, ValueWrapper> values = new LinkedHashMap<String, ValueWrapper>();
    private T instance;
    private LastPropertyModel lastPropertyModel;

    protected ObjectDeserializer(DeserializerBuilder builder) {
        super(builder);
    }

    @Override
    public T getInstance(Unmarshaller unmarshaller) {
        if (this.instance != null) {
            return this.instance;
        }
        Class<?> rawType = ReflectionUtils.getRawType(this.getRuntimeType());
        JsonbCreator creator = this.getClassModel().getClassCustomization().getCreator();
        if (creator != null) {
            this.instance = this.createInstance(rawType, creator);
        } else {
            Constructor<?> defaultConstructor = this.getClassModel().getDefaultConstructor();
            if (defaultConstructor == null) {
                throw new JsonbException(Messages.getMessage(MessageKeys.NO_DEFAULT_CONSTRUCTOR, rawType));
            }
            this.instance = ReflectionUtils.createNoArgConstructorInstance(defaultConstructor);
        }
        this.values.forEach((key, wrapper) -> {
            if (wrapper.getCreatorModel() != null) {
                return;
            }
            PropertyModel propertyModel = wrapper.getPropertyModel();
            propertyModel.setValue(this.instance, wrapper.getValue());
        });
        return this.instance;
    }

    private T createInstance(Class<T> rawType, JsonbCreator creator) {
        ArrayList<Object> paramValues = new ArrayList<Object>();
        for (CreatorModel param : creator.getParams()) {
            ValueWrapper valueWrapper = this.values.get(param.getName());
            if (valueWrapper == null) {
                throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CREATOR_MISSING_PROPERTY, param.getName()));
            }
            paramValues.add(valueWrapper.getValue());
        }
        T instance = creator.call(paramValues.toArray(), rawType);
        return instance;
    }

    @Override
    public void appendResult(Object result) {
        PropertyModel model = this.getModel();
        if (model == null) {
            return;
        }
        this.values.put(model.getReadName(), new ValueWrapper(model, this.convertNullToOptionalEmpty(model.getPropertyDeserializationType(), result)));
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        CreatorModel param;
        JsonbCreator creator = this.getClassModel().getClassCustomization().getCreator();
        if (creator != null && (param = creator.findByName(this.getParserContext().getLastKeyName())) != null) {
            JsonbDeserializer<?> deserializer = ((DeserializerBuilder)((DeserializerBuilder)this.newUnmarshallerItemBuilder(context.getJsonbContext()).withType(param.getType())).withCustomization(param.getCustomization())).build();
            Object result = deserializer.deserialize(parser, context, param.getType());
            this.values.put(param.getName(), new ValueWrapper(param, result));
            return;
        }
        PropertyModel newPropertyModel = this.getModel();
        if (newPropertyModel != null && newPropertyModel.isWritable()) {
            JsonbDeserializer<?> deserializer = ((DeserializerBuilder)((DeserializerBuilder)this.newUnmarshallerItemBuilder(context.getJsonbContext()).withCustomization(newPropertyModel.getCustomization())).withType(newPropertyModel.getPropertyDeserializationType())).build();
            Type resolvedType = ReflectionUtils.resolveType(this, newPropertyModel.getPropertyDeserializationType());
            Object result = deserializer.deserialize(parser, context, resolvedType);
            this.values.put(newPropertyModel.getPropertyName(), new ValueWrapper(newPropertyModel, result));
            return;
        }
        this.skipJsonProperty((JsonbParser)parser, context.getJsonbContext());
    }

    private void skipJsonProperty(JsonbParser parser, JsonbContext jsonbContext) {
        if (jsonbContext.getConfigProperties().getConfigFailOnUnknownProperties()) {
            throw new JsonbException(Messages.getMessage(MessageKeys.UNKNOWN_JSON_PROPERTY, this.getParserContext().getLastKeyName(), this.getRuntimeType()));
        }
        parser.skipJsonStructure();
    }

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveTo(JsonParser.Event.START_OBJECT);
        return parser.getCurrentLevel();
    }

    protected PropertyModel getModel() {
        String lastKeyName = this.getParserContext().getLastKeyName();
        if (this.lastPropertyModel != null && this.lastPropertyModel.getJsonKeyName().equals(lastKeyName)) {
            return this.lastPropertyModel.getPropertyModel();
        }
        this.lastPropertyModel = new LastPropertyModel(lastKeyName, this.getClassModel().findPropertyModelByJsonReadName(lastKeyName));
        return this.lastPropertyModel.getPropertyModel();
    }

    private static class ValueWrapper {
        private final CreatorModel creatorModel;
        private final PropertyModel propertyModel;
        private final Object value;

        ValueWrapper(CreatorModel creator, Object value) {
            this.creatorModel = creator;
            this.value = value;
            this.propertyModel = null;
        }

        ValueWrapper(PropertyModel propertyModel, Object value) {
            this.propertyModel = propertyModel;
            this.value = value;
            this.creatorModel = null;
        }

        public CreatorModel getCreatorModel() {
            return this.creatorModel;
        }

        public PropertyModel getPropertyModel() {
            return this.propertyModel;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static class LastPropertyModel {
        private final String jsonKeyName;
        private final PropertyModel propertyModel;

        LastPropertyModel(String jsonKeyName, PropertyModel propertyModel) {
            this.jsonKeyName = jsonKeyName;
            this.propertyModel = propertyModel;
        }

        public String getJsonKeyName() {
            return this.jsonKeyName;
        }

        public PropertyModel getPropertyModel() {
            return this.propertyModel;
        }
    }
}

