/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.GeoBounds;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class GeoTileGridAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final String field;
    @Nullable
    private final Number precision;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer size;
    @Nullable
    private final GeoBounds bounds;
    public static final JsonpDeserializer<GeoTileGridAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoTileGridAggregation::setupGeoTileGridAggregationDeserializer);

    private GeoTileGridAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.precision = builder.precision;
        this.shardSize = builder.shardSize;
        this.size = builder.size;
        this.bounds = builder.bounds;
    }

    public static GeoTileGridAggregation of(Function<Builder, ObjectBuilder<GeoTileGridAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeotileGrid;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Number precision() {
        return this.precision;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final GeoBounds bounds() {
        return this.bounds;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision.doubleValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
    }

    protected static void setupGeoTileGridAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::precision, JsonpDeserializer.numberDeserializer(), "precision");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::bounds, GeoBounds._DESERIALIZER, "bounds");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoTileGridAggregation> {
        @Nullable
        private String field;
        @Nullable
        private Number precision;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer size;
        @Nullable
        private GeoBounds bounds;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder precision(@Nullable Number value) {
            this.precision = value;
            return this;
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder bounds(@Nullable GeoBounds value) {
            this.bounds = value;
            return this;
        }

        public final Builder bounds(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.bounds(fn.apply(new GeoBounds.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoTileGridAggregation build() {
            this._checkSingleUse();
            return new GeoTileGridAggregation(this);
        }
    }
}

