/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class MetricAggregationBase
implements PlainJsonSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final FieldValue missing;
    @Nullable
    private final Script script;

    protected MetricAggregationBase(AbstractBuilder<?> builder) {
        this.field = ((AbstractBuilder)builder).field;
        this.missing = ((AbstractBuilder)builder).missing;
        this.script = ((AbstractBuilder)builder).script;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMetricAggregationBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(AbstractBuilder::missing, FieldValue._DESERIALIZER, "missing");
        op.add(AbstractBuilder::script, Script._DESERIALIZER, "script");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String field;
        @Nullable
        private FieldValue missing;
        @Nullable
        private Script script;

        protected AbstractBuilder() {
        }

        public final BuilderT field(@Nullable String value) {
            this.field = value;
            return this.self();
        }

        public final BuilderT missing(@Nullable FieldValue value) {
            this.missing = value;
            return this.self();
        }

        public final BuilderT missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        public final BuilderT script(@Nullable Script value) {
            this.script = value;
            return this.self();
        }

        public final BuilderT script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        protected abstract BuilderT self();
    }
}

