/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationRange;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class RangeAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final String field;
    @Nullable
    private final Integer missing;
    private final List<AggregationRange> ranges;
    @Nullable
    private final Script script;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<RangeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RangeAggregation::setupRangeAggregationDeserializer);

    private RangeAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.missing = builder.missing;
        this.ranges = ApiTypeHelper.unmodifiable(builder.ranges);
        this.script = builder.script;
        this.keyed = builder.keyed;
    }

    public static RangeAggregation of(Function<Builder, ObjectBuilder<RangeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Range;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer missing() {
        return this.missing;
    }

    public final List<AggregationRange> ranges() {
        return this.ranges;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing);
        }
        if (ApiTypeHelper.isDefined(this.ranges)) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (AggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed);
        }
    }

    protected static void setupRangeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        RangeAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::missing, JsonpDeserializer.integerDeserializer(), "missing");
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(AggregationRange._DESERIALIZER), "ranges");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RangeAggregation> {
        @Nullable
        private String field;
        @Nullable
        private Integer missing;
        @Nullable
        private List<AggregationRange> ranges;
        @Nullable
        private Script script;
        @Nullable
        private Boolean keyed;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder missing(@Nullable Integer value) {
            this.missing = value;
            return this;
        }

        public final Builder ranges(List<AggregationRange> list) {
            this.ranges = Builder._listAddAll(this.ranges, list);
            return this;
        }

        public final Builder ranges(AggregationRange value, AggregationRange ... values) {
            this.ranges = Builder._listAdd(this.ranges, value, values);
            return this;
        }

        public final Builder ranges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.ranges(fn.apply(new AggregationRange.Builder()).build(), new AggregationRange[0]);
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RangeAggregation build() {
            this._checkSingleUse();
            return new RangeAggregation(this);
        }
    }
}

