/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.EdgeNGramSide;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class EdgeNGramTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final int maxGram;
    private final int minGram;
    @Nullable
    private final EdgeNGramSide side;
    @Nullable
    private final Boolean preserveOriginal;
    public static final JsonpDeserializer<EdgeNGramTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EdgeNGramTokenFilter::setupEdgeNGramTokenFilterDeserializer);

    private EdgeNGramTokenFilter(Builder builder) {
        super(builder);
        this.maxGram = ApiTypeHelper.requireNonNull(builder.maxGram, this, "maxGram");
        this.minGram = ApiTypeHelper.requireNonNull(builder.minGram, this, "minGram");
        this.side = builder.side;
        this.preserveOriginal = builder.preserveOriginal;
    }

    public static EdgeNGramTokenFilter of(Function<Builder, ObjectBuilder<EdgeNGramTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.EdgeNgram;
    }

    public final int maxGram() {
        return this.maxGram;
    }

    public final int minGram() {
        return this.minGram;
    }

    @Nullable
    public final EdgeNGramSide side() {
        return this.side;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "edge_ngram");
        super.serializeInternal(generator, mapper);
        generator.writeKey("max_gram");
        generator.write(this.maxGram);
        generator.writeKey("min_gram");
        generator.write(this.minGram);
        if (this.side != null) {
            generator.writeKey("side");
            this.side.serialize(generator, mapper);
        }
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal);
        }
    }

    protected static void setupEdgeNGramTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        EdgeNGramTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram");
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram");
        op.add(Builder::side, EdgeNGramSide._DESERIALIZER, "side");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EdgeNGramTokenFilter> {
        private Integer maxGram;
        private Integer minGram;
        @Nullable
        private EdgeNGramSide side;
        @Nullable
        private Boolean preserveOriginal;

        public final Builder maxGram(int value) {
            this.maxGram = value;
            return this;
        }

        public final Builder minGram(int value) {
            this.minGram = value;
            return this;
        }

        public final Builder side(@Nullable EdgeNGramSide value) {
            this.side = value;
            return this;
        }

        public final Builder preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EdgeNGramTokenFilter build() {
            this._checkSingleUse();
            return new EdgeNGramTokenFilter(this);
        }
    }
}

