/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Pipeline
implements PlainJsonSerializable {
    @Nullable
    private final String description;
    private final List<Processor> onFailure;
    private final List<Processor> processors;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<Pipeline> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pipeline::setupPipelineDeserializer);

    private Pipeline(Builder builder) {
        this.description = builder.description;
        this.onFailure = ApiTypeHelper.unmodifiable(builder.onFailure);
        this.processors = ApiTypeHelper.unmodifiable(builder.processors);
        this.version = builder.version;
    }

    public static Pipeline of(Function<Builder, ObjectBuilder<Pipeline>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final List<Processor> onFailure() {
        return this.onFailure;
    }

    public final List<Processor> processors() {
        return this.processors;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.onFailure)) {
            generator.writeKey("on_failure");
            generator.writeStartArray();
            for (Processor item0 : this.onFailure) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.processors)) {
            generator.writeKey("processors");
            generator.writeStartArray();
            for (Processor item0 : this.processors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
    }

    protected static void setupPipelineDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure");
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "processors");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Pipeline> {
        @Nullable
        private String description;
        @Nullable
        private List<Processor> onFailure;
        @Nullable
        private List<Processor> processors;
        @Nullable
        private Long version;

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder onFailure(List<Processor> list) {
            this.onFailure = Builder._listAddAll(this.onFailure, list);
            return this;
        }

        public final Builder onFailure(Processor value, Processor ... values) {
            this.onFailure = Builder._listAdd(this.onFailure, value, values);
            return this;
        }

        public final Builder onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.onFailure(fn.apply(new Processor.Builder()).build(), new Processor[0]);
        }

        public final Builder processors(List<Processor> list) {
            this.processors = Builder._listAddAll(this.processors, list);
            return this;
        }

        public final Builder processors(Processor value, Processor ... values) {
            this.processors = Builder._listAdd(this.processors, value, values);
            return this;
        }

        public final Builder processors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.processors(fn.apply(new Processor.Builder()).build(), new Processor[0]);
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        public Pipeline build() {
            this._checkSingleUse();
            return new Pipeline(this);
        }
    }
}

