/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class ProcessorBase
implements PlainJsonSerializable {
    @Nullable
    private final String if_;
    @Nullable
    private final Boolean ignoreFailure;
    private final List<Processor> onFailure;
    @Nullable
    private final String tag;

    protected ProcessorBase(AbstractBuilder<?> builder) {
        this.if_ = ((AbstractBuilder)builder).if_;
        this.ignoreFailure = ((AbstractBuilder)builder).ignoreFailure;
        this.onFailure = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).onFailure);
        this.tag = ((AbstractBuilder)builder).tag;
    }

    @Nullable
    public final String if_() {
        return this.if_;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    public final List<Processor> onFailure() {
        return this.onFailure;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.if_ != null) {
            generator.writeKey("if");
            generator.write(this.if_);
        }
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure);
        }
        if (ApiTypeHelper.isDefined(this.onFailure)) {
            generator.writeKey("on_failure");
            generator.writeStartArray();
            for (Processor item0 : this.onFailure) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupProcessorBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::if_, JsonpDeserializer.stringDeserializer(), "if");
        op.add(AbstractBuilder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(AbstractBuilder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure");
        op.add(AbstractBuilder::tag, JsonpDeserializer.stringDeserializer(), "tag");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String if_;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private List<Processor> onFailure;
        @Nullable
        private String tag;

        protected AbstractBuilder() {
        }

        public final BuilderT if_(@Nullable String value) {
            this.if_ = value;
            return this.self();
        }

        public final BuilderT ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this.self();
        }

        public final BuilderT onFailure(List<Processor> list) {
            this.onFailure = AbstractBuilder._listAddAll(this.onFailure, list);
            return this.self();
        }

        public final BuilderT onFailure(Processor value, Processor ... values) {
            this.onFailure = AbstractBuilder._listAdd(this.onFailure, value, values);
            return this.self();
        }

        public final BuilderT onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.onFailure(fn.apply(new Processor.Builder()).build(), new Processor[0]);
        }

        public final BuilderT tag(@Nullable String value) {
            this.tag = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

