/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.RegisterModelGroupResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RegisterModelGroupRequest
extends RequestBase
implements PlainJsonSerializable {
    @Nullable
    private final String accessMode;
    @Nullable
    private final Boolean addAllBackendRoles;
    private final List<String> backendRoles;
    @Nullable
    private final String description;
    private final String name;
    public static final JsonpDeserializer<RegisterModelGroupRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RegisterModelGroupRequest::setupRegisterModelGroupRequestDeserializer);
    public static final Endpoint<RegisterModelGroupRequest, RegisterModelGroupResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RegisterModelGroupRequest, RegisterModelGroupResponse>(request -> "POST", request -> "/_plugins/_ml/model_groups/_register", SimpleEndpoint.emptyMap(), SimpleEndpoint.emptyMap(), true, RegisterModelGroupResponse._DESERIALIZER);

    private RegisterModelGroupRequest(Builder builder) {
        this.accessMode = builder.accessMode;
        this.addAllBackendRoles = builder.addAllBackendRoles;
        this.backendRoles = ApiTypeHelper.unmodifiable(builder.backendRoles);
        this.description = builder.description;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static RegisterModelGroupRequest of(Function<Builder, ObjectBuilder<RegisterModelGroupRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String accessMode() {
        return this.accessMode;
    }

    @Nullable
    public final Boolean addAllBackendRoles() {
        return this.addAllBackendRoles;
    }

    public final List<String> backendRoles() {
        return this.backendRoles;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.accessMode != null) {
            generator.writeKey("access_mode");
            generator.write(this.accessMode);
        }
        if (this.addAllBackendRoles != null) {
            generator.writeKey("add_all_backend_roles");
            generator.write(this.addAllBackendRoles);
        }
        if (ApiTypeHelper.isDefined(this.backendRoles)) {
            generator.writeKey("backend_roles");
            generator.writeStartArray();
            for (String item0 : this.backendRoles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    protected static void setupRegisterModelGroupRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessMode, JsonpDeserializer.stringDeserializer(), "access_mode");
        op.add(Builder::addAllBackendRoles, JsonpDeserializer.booleanDeserializer(), "add_all_backend_roles");
        op.add(Builder::backendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backend_roles");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RegisterModelGroupRequest> {
        @Nullable
        private String accessMode;
        @Nullable
        private Boolean addAllBackendRoles;
        @Nullable
        private List<String> backendRoles;
        @Nullable
        private String description;
        private String name;

        public final Builder accessMode(@Nullable String value) {
            this.accessMode = value;
            return this;
        }

        public final Builder addAllBackendRoles(@Nullable Boolean value) {
            this.addAllBackendRoles = value;
            return this;
        }

        public final Builder backendRoles(List<String> list) {
            this.backendRoles = Builder._listAddAll(this.backendRoles, list);
            return this;
        }

        public final Builder backendRoles(String value, String ... values) {
            this.backendRoles = Builder._listAdd(this.backendRoles, value, values);
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        public RegisterModelGroupRequest build() {
            this._checkSingleUse();
            return new RegisterModelGroupRequest(this);
        }
    }
}

