/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.paho.PahoEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PahoProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PahoProducer.class);
    private volatile MqttClient client;
    private volatile String clientId;
    private volatile boolean stopClient;
    private volatile MqttConnectOptions connectOptions;

    public PahoProducer(PahoEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            exchange.setException(new RejectedExecutionException());
        } else {
            try {
                String topic = exchange.getIn().getHeader("CamelPahoOverrideTopic", this.getEndpoint().getTopic(), String.class);
                int qos = exchange.getIn().getHeader("CamelPahoQos", this.getEndpoint().getConfiguration().getQos(), Integer.class);
                boolean retained = exchange.getIn().getHeader("CamelPahoRetained", this.getEndpoint().getConfiguration().isRetained(), Boolean.class);
                byte[] payload = exchange.getIn().getBody(byte[].class);
                MqttMessage message = new MqttMessage(payload);
                message.setQos(qos);
                message.setRetained(retained);
                LOG.debug("Publishing to topic: {}, qos: {}, retrained: {}", new Object[]{topic, qos, retained});
                this.client.publish(topic, message);
            }
            catch (MqttException e) {
                exchange.setException(e);
            }
        }
        callback.done(true);
        return true;
    }

    @Override
    public PahoEndpoint getEndpoint() {
        return (PahoEndpoint)super.getEndpoint();
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.connectOptions = PahoEndpoint.createMqttConnectOptions(this.getEndpoint().getConfiguration());
        if (this.client == null) {
            this.clientId = this.getEndpoint().getConfiguration().getClientId();
            if (this.clientId == null) {
                this.clientId = "camel-" + MqttClient.generateClientId();
            }
            this.stopClient = true;
            this.client = new MqttClient(this.getEndpoint().getConfiguration().getBrokerUrl(), this.clientId, PahoEndpoint.createMqttClientPersistence(this.getEndpoint().getConfiguration()));
            LOG.debug("Connecting client: {} to broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.connect(this.connectOptions);
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.stopClient && this.client != null && this.client.isConnected()) {
            LOG.debug("Disconnecting client: {} from broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.disconnect();
        }
        this.client = null;
    }
}

