/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttDataTypes;
import org.eclipse.paho.mqttv5.common.packet.MqttPersistableWireMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.util.CountingInputStream;

public class MqttUnsubscribe
extends MqttPersistableWireMessage {
    private static final Byte[] validProperties = new Byte[]{(byte)38};
    private String[] topics;
    private MqttProperties properties;

    public MqttUnsubscribe(byte[] data) throws IOException, MqttException {
        super((byte)10);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream inputStream = new DataInputStream(counter);
        this.msgId = inputStream.readUnsignedShort();
        this.properties.decodeProperties(inputStream);
        ArrayList<String> topicList = new ArrayList<String>();
        while (counter.getCounter() < data.length) {
            topicList.add(MqttDataTypes.decodeUTF8(inputStream));
        }
        this.topics = topicList.toArray(new String[topicList.size()]);
        inputStream.close();
    }

    public MqttUnsubscribe(String[] topics, MqttProperties properties) {
        super((byte)10);
        this.topics = topics;
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            outputStream.writeShort(this.msgId);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            outputStream.write(identifierValueFieldsByteArray);
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            String[] stringArray = this.topics;
            int n = this.topics.length;
            int n2 = 0;
            while (n2 < n) {
                String topic = stringArray[n2];
                MqttDataTypes.encodeUTF8(outputStream, topic);
                ++n2;
            }
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void setTopics(String[] topics) {
        this.topics = topics;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttUnsubscribe [topics=" + Arrays.toString(this.topics) + ", properties=" + this.properties + "]";
    }
}

