/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import org.eclipse.paho.mqttv5.client.BufferedMessage;
import org.eclipse.paho.mqttv5.client.IMqttMessageListener;
import org.eclipse.paho.mqttv5.client.MqttActionListener;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClientInterface;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttPingSender;
import org.eclipse.paho.mqttv5.client.MqttToken;
import org.eclipse.paho.mqttv5.client.MqttTopic;
import org.eclipse.paho.mqttv5.client.internal.ClientState;
import org.eclipse.paho.mqttv5.client.internal.CommsCallback;
import org.eclipse.paho.mqttv5.client.internal.CommsReceiver;
import org.eclipse.paho.mqttv5.client.internal.CommsSender;
import org.eclipse.paho.mqttv5.client.internal.CommsTokenStore;
import org.eclipse.paho.mqttv5.client.internal.DisconnectedMessageBuffer;
import org.eclipse.paho.mqttv5.client.internal.ExceptionHelper;
import org.eclipse.paho.mqttv5.client.internal.IDisconnectedBufferCallback;
import org.eclipse.paho.mqttv5.client.internal.MqttConnectionState;
import org.eclipse.paho.mqttv5.client.internal.MqttSessionState;
import org.eclipse.paho.mqttv5.client.internal.MqttState;
import org.eclipse.paho.mqttv5.client.internal.NetworkModule;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttPersistenceException;
import org.eclipse.paho.mqttv5.common.packet.MqttConnAck;
import org.eclipse.paho.mqttv5.common.packet.MqttConnect;
import org.eclipse.paho.mqttv5.common.packet.MqttDisconnect;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;
import org.eclipse.paho.mqttv5.common.packet.MqttWireMessage;

public class ClientComms {
    public static String VERSION = "${project.version}";
    public static String BUILD_LEVEL = "L${build.level}";
    private static final String CLASS_NAME = ClientComms.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private static final byte CONNECTED = 0;
    private static final byte CONNECTING = 1;
    private static final byte DISCONNECTING = 2;
    private static final byte DISCONNECTED = 3;
    private static final byte CLOSED = 4;
    private MqttClientInterface client;
    private int networkModuleIndex;
    private NetworkModule[] networkModules;
    private CommsReceiver receiver;
    private CommsSender sender;
    private CommsCallback callback;
    private ClientState clientState;
    private MqttConnectionOptions conOptions;
    private MqttClientPersistence persistence;
    private MqttPingSender pingSender;
    private CommsTokenStore tokenStore;
    private boolean stoppingComms = false;
    private byte conState = (byte)3;
    private final Object conLock = new Object();
    private boolean closePending = false;
    private boolean resting = false;
    private DisconnectedMessageBuffer disconnectedMessageBuffer;
    private ExecutorService executorService;
    private MqttConnectionState mqttConnection;

    public ClientComms(MqttClientInterface client, MqttClientPersistence persistence, MqttPingSender pingSender, ExecutorService executorService, MqttSessionState mqttSession, MqttConnectionState mqttConnection) throws MqttException {
        this.conState = (byte)3;
        this.client = client;
        this.persistence = persistence;
        this.pingSender = pingSender;
        this.pingSender.init(this);
        this.executorService = executorService;
        this.mqttConnection = mqttConnection;
        this.tokenStore = new CommsTokenStore(this.getClient().getClientId());
        this.callback = new CommsCallback(this);
        this.clientState = new ClientState(persistence, this.tokenStore, this.callback, this, pingSender, this.mqttConnection);
        this.callback.setClientState(this.clientState);
        this.log.setResourceName(this.getClient().getClientId());
    }

    CommsReceiver getReceiver() {
        return this.receiver;
    }

    void internalSend(MqttWireMessage message, MqttToken token) throws MqttException {
        this.log.fine(CLASS_NAME, "internalSend", "200", new Object[]{message.getKey(), message, token});
        if (token.getClient() != null) {
            this.log.fine(CLASS_NAME, "internalSend", "213", new Object[]{message.getKey(), message, token});
            throw new MqttException(32201);
        }
        token.internalTok.setClient(this.getClient());
        try {
            this.clientState.send(message, token);
        }
        catch (MqttException e) {
            token.internalTok.setClient(null);
            if (message instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)message);
            }
            throw e;
        }
    }

    public void sendNoWait(MqttWireMessage message, MqttToken token) throws MqttException {
        if (this.isConnected() || !this.isConnected() && message instanceof MqttConnect || this.isDisconnecting() && message instanceof MqttDisconnect) {
            if (this.disconnectedMessageBuffer != null && this.disconnectedMessageBuffer.getMessageCount() != 0) {
                this.log.fine(CLASS_NAME, "sendNoWait", "507", new Object[]{message.getKey()});
                if (message instanceof MqttPublish && message.getProperties().getTopicAlias() != null) {
                    MqttProperties messageProps = message.getProperties();
                    messageProps.setTopicAlias(null);
                    message.setProperties(messageProps);
                }
                if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                    this.clientState.persistBufferedMessage(message);
                }
                this.disconnectedMessageBuffer.putMessage(message, token);
            } else {
                if (message instanceof MqttPublish) {
                    MqttMessage mqttMessage;
                    if (this.mqttConnection.getMaximumQoS() != null && ((MqttPublish)message).getMessage().getQos() > this.mqttConnection.getMaximumQoS()) {
                        mqttMessage = ((MqttPublish)message).getMessage();
                        mqttMessage.setQos(this.mqttConnection.getMaximumQoS());
                        ((MqttPublish)message).setMessage(mqttMessage);
                    }
                    if (this.mqttConnection.isRetainAvailable() != null && ((MqttPublish)message).getMessage().isRetained() && !this.mqttConnection.isRetainAvailable().booleanValue()) {
                        mqttMessage = ((MqttPublish)message).getMessage();
                        mqttMessage.setRetained(false);
                        ((MqttPublish)message).setMessage(mqttMessage);
                    }
                }
                this.internalSend(message, token);
            }
        } else if (this.disconnectedMessageBuffer != null && this.isResting()) {
            this.log.fine(CLASS_NAME, "sendNoWait", "508", new Object[]{message.getKey()});
            if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                this.clientState.persistBufferedMessage(message);
            }
            this.disconnectedMessageBuffer.putMessage(message, token);
        } else {
            this.log.fine(CLASS_NAME, "sendNoWait", "208");
            throw ExceptionHelper.createMqttException(32104);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) throws MqttException {
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected() || force) {
                    this.log.fine(CLASS_NAME, "close", "224");
                    if (this.isConnecting()) {
                        throw new MqttException(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.pingSender = null;
                this.receiver = null;
                this.networkModules = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MqttConnectionOptions options, MqttToken token) throws MqttException {
        Object object = this.conLock;
        synchronized (object) {
            MqttConnect connect;
            if (this.isDisconnected() && !this.closePending) {
                this.log.fine(CLASS_NAME, "connect", "214");
                this.conState = 1;
                this.conOptions = options;
                connect = new MqttConnect(this.client.getClientId(), this.conOptions.getMqttVersion(), this.conOptions.isCleanStart(), this.conOptions.getKeepAliveInterval(), this.conOptions.getConnectionProperties(), this.conOptions.getWillMessageProperties());
                if (this.conOptions.getWillDestination() != null) {
                    connect.setWillDestination(this.conOptions.getWillDestination());
                }
                if (this.conOptions.getWillMessage() != null) {
                    connect.setWillMessage(this.conOptions.getWillMessage());
                }
                if (this.conOptions.getUserName() != null) {
                    connect.setUserName(this.conOptions.getUserName());
                }
                if (this.conOptions.getPassword() != null) {
                    connect.setPassword(this.conOptions.getPassword());
                }
            } else {
                this.log.fine(CLASS_NAME, "connect", "207", new Object[]{this.conState});
                if (this.isClosed() || this.closePending) {
                    throw new MqttException(32111);
                }
                if (this.isConnecting()) {
                    throw new MqttException(32110);
                }
                if (this.isDisconnecting()) {
                    throw new MqttException(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            this.mqttConnection.setKeepAliveSeconds(this.conOptions.getKeepAliveInterval());
            this.clientState.setCleanStart(this.conOptions.isCleanStart());
            this.tokenStore.open();
            ConnectBG conbg = new ConnectBG(this, token, connect, this.executorService);
            conbg.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectComplete(MqttConnAck cack, MqttException mex) throws MqttException {
        int rc = cack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (rc == 0) {
                this.log.fine(CLASS_NAME, "connectComplete", "215");
                this.conState = 0;
                return;
            }
        }
        this.log.fine(CLASS_NAME, "connectComplete", "204", new Object[]{rc});
        throw mex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownConnection(MqttToken token, MqttException reason, MqttDisconnect message) {
        boolean wasConnected;
        MqttToken endToken = null;
        Object object = this.conLock;
        synchronized (object) {
            if (this.stoppingComms || this.closePending || this.isClosed()) {
                return;
            }
            this.stoppingComms = true;
            this.log.fine(CLASS_NAME, "shutdownConnection", "216");
            wasConnected = this.isConnected() || this.isDisconnecting();
            this.conState = (byte)2;
        }
        if (token != null && !token.isComplete()) {
            token.internalTok.setException(reason);
        }
        if (this.callback != null) {
            this.callback.stop();
        }
        if (this.receiver != null) {
            this.receiver.stop();
        }
        try {
            NetworkModule networkModule;
            if (this.networkModules != null && (networkModule = this.networkModules[this.networkModuleIndex]) != null) {
                networkModule.stop();
            }
        }
        catch (Exception exception) {}
        this.tokenStore.quiesce(new MqttException(32102));
        endToken = this.handleOldTokens(token, reason);
        try {
            this.clientState.disconnected(reason);
            if (this.clientState.getCleanStart()) {
                this.callback.removeMessageListeners();
            }
        }
        catch (Exception exception) {}
        if (this.sender != null) {
            this.sender.stop();
        }
        if (this.pingSender != null) {
            this.pingSender.stop();
        }
        try {
            if (this.disconnectedMessageBuffer == null && this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception exception) {}
        object = this.conLock;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "shutdownConnection", "217");
            this.conState = (byte)3;
            this.stoppingComms = false;
        }
        if (endToken != null && this.callback != null) {
            this.callback.asyncOperationComplete(endToken);
        }
        if (wasConnected && this.callback != null) {
            this.callback.connectionLost(reason, message);
        }
        object = this.conLock;
        synchronized (object) {
            if (this.closePending) {
                try {
                    this.close(true);
                }
                catch (Exception exception) {}
            }
        }
    }

    private MqttToken handleOldTokens(MqttToken token, MqttException reason) {
        this.log.fine(CLASS_NAME, "handleOldTokens", "222");
        MqttToken tokToNotifyLater = null;
        try {
            if (token != null && this.tokenStore.getToken(token.internalTok.getKey()) == null) {
                this.tokenStore.saveToken(token, token.internalTok.getKey());
            }
            Vector<MqttToken> toksToNot = this.clientState.resolveOldTokens(reason);
            Enumeration<MqttToken> toksToNotE = toksToNot.elements();
            while (toksToNotE.hasMoreElements()) {
                MqttToken tok = toksToNotE.nextElement();
                if (tok.internalTok.getKey().equals("Disc") || tok.internalTok.getKey().equals("Con")) {
                    tokToNotifyLater = tok;
                    continue;
                }
                this.callback.asyncOperationComplete(tok);
            }
        }
        catch (Exception exception) {}
        return tokToNotifyLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) throws MqttException {
        Object object = this.conLock;
        synchronized (object) {
            if (this.isClosed()) {
                this.log.fine(CLASS_NAME, "disconnect", "223");
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                this.log.fine(CLASS_NAME, "disconnect", "211");
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                this.log.fine(CLASS_NAME, "disconnect", "219");
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                this.log.fine(CLASS_NAME, "disconnect", "210");
                throw ExceptionHelper.createMqttException(32107);
            }
            this.log.fine(CLASS_NAME, "disconnect", "218");
            this.conState = (byte)2;
            DisconnectBG discbg = new DisconnectBG(disconnect, quiesceTimeout, token, this.executorService);
            discbg.start();
        }
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout, int reasonCode, MqttProperties disconnectProperties) throws MqttException {
        this.disconnectForcibly(quiesceTimeout, disconnectTimeout, true, reasonCode, disconnectProperties);
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout, boolean sendDisconnectPacket, int reasonCode, MqttProperties disconnectProperties) throws MqttException {
        this.conState = (byte)2;
        if (this.clientState != null) {
            this.clientState.quiesce(quiesceTimeout);
        }
        MqttToken token = new MqttToken(this.client.getClientId());
        try {
            try {
                if (sendDisconnectPacket) {
                    this.internalSend(new MqttDisconnect(reasonCode, disconnectProperties), token);
                    token.waitForCompletion(disconnectTimeout);
                }
            }
            catch (Exception exception) {
                token.internalTok.markComplete(null, null);
                this.shutdownConnection(token, null, null);
            }
        }
        finally {
            token.internalTok.markComplete(null, null);
            this.shutdownConnection(token, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.resting;
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    public void setReconnectCallback(MqttCallback callback) {
        this.callback.setReconnectCallback(callback);
    }

    public void setManualAcks(boolean manualAcks) {
        this.callback.setManualAcks(manualAcks);
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.callback.messageArrivedComplete(messageId, qos);
    }

    public void setMessageListener(Integer subscriptionId, String topicFilter, IMqttMessageListener messageListener) {
        this.callback.setMessageListener(subscriptionId, topicFilter, messageListener);
    }

    public void removeMessageListener(String topicFilter) {
        this.callback.removeMessageListener(topicFilter);
    }

    protected MqttTopic getTopic(String topic) {
        return new MqttTopic(topic, this);
    }

    public void setNetworkModuleIndex(int index) {
        this.networkModuleIndex = index;
    }

    public int getNetworkModuleIndex() {
        return this.networkModuleIndex;
    }

    public NetworkModule[] getNetworkModules() {
        return this.networkModules;
    }

    public void setNetworkModules(NetworkModule[] networkModules) {
        this.networkModules = networkModules;
    }

    public MqttToken[] getPendingTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish msg) throws MqttPersistenceException {
        this.clientState.deliveryComplete(msg);
    }

    protected void deliveryComplete(int messageId) throws MqttPersistenceException {
        this.clientState.deliveryComplete(messageId);
    }

    public MqttClientInterface getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.mqttConnection.getKeepAlive();
    }

    public MqttState getClientState() {
        return this.clientState;
    }

    public MqttConnectionOptions getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties props = new Properties();
        props.put("conState", (Object)this.conState);
        props.put("serverURI", this.getClient().getServerURI());
        props.put("callback", this.callback);
        props.put("stoppingComms", (Object)this.stoppingComms);
        return props;
    }

    public MqttToken checkForActivity() {
        return this.checkForActivity(null);
    }

    public MqttToken checkForActivity(MqttActionListener pingCallback) {
        MqttToken token = null;
        try {
            token = this.clientState.checkForActivity(pingCallback);
        }
        catch (MqttException e) {
            this.handleRunException(e);
        }
        catch (Exception e) {
            this.handleRunException(e);
        }
        return token;
    }

    private void handleRunException(Exception ex) {
        this.log.fine(CLASS_NAME, "handleRunException", "804", null, ex);
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        this.shutdownConnection(null, mex, null);
    }

    public void setRestingState(boolean resting) {
        this.resting = resting;
    }

    public void setDisconnectedMessageBuffer(DisconnectedMessageBuffer disconnectedMessageBuffer) {
        this.disconnectedMessageBuffer = disconnectedMessageBuffer;
    }

    public int getBufferedMessageCount() {
        return this.disconnectedMessageBuffer.getMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        MqttPublish send = (MqttPublish)this.disconnectedMessageBuffer.getMessage(bufferIndex).getMessage();
        return send.getMessage();
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.disconnectedMessageBuffer.deleteMessage(bufferIndex);
    }

    public void notifyReconnect() {
        if (this.disconnectedMessageBuffer != null) {
            this.log.fine(CLASS_NAME, "notifyReconnect", "509");
            this.disconnectedMessageBuffer.setPublishCallback(new ReconnectDisconnectedBufferCallback("notifyReconnect"));
            if (this.executorService == null) {
                new Thread(this.disconnectedMessageBuffer).start();
            } else {
                this.executorService.execute(this.disconnectedMessageBuffer);
            }
        }
    }

    public int getActualInFlight() {
        return this.clientState.getActualInFlight();
    }

    public boolean doesSubscriptionIdentifierExist(int subscriptionIdentifier) {
        return this.callback.doesSubscriptionIdentifierExist(subscriptionIdentifier);
    }

    private class ConnectBG
    implements Runnable {
        ClientComms clientComms = null;
        MqttToken conToken;
        MqttConnect conPacket;
        private String threadName;

        ConnectBG(ClientComms cc, MqttToken cToken, MqttConnect cPacket, ExecutorService executorService) {
            this.clientComms = cc;
            this.conToken = cToken;
            this.conPacket = cPacket;
            this.threadName = "MQTT Con: " + ClientComms.this.getClient().getClientId();
        }

        void start() {
            if (ClientComms.this.executorService == null) {
                new Thread(this).start();
            } else {
                ClientComms.this.executorService.execute(this);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.threadName);
            MqttException mqttEx = null;
            ClientComms.this.log.fine(CLASS_NAME, "connectBG:run", "220");
            try {
                MqttToken[] toks;
                MqttToken[] mqttTokenArray = toks = ClientComms.this.tokenStore.getOutstandingDelTokens();
                int n = toks.length;
                int n2 = 0;
                while (n2 < n) {
                    MqttToken tok = mqttTokenArray[n2];
                    tok.internalTok.setException(null);
                    ++n2;
                }
                ClientComms.this.tokenStore.saveToken(this.conToken, this.conPacket);
                NetworkModule networkModule = ClientComms.this.networkModules[ClientComms.this.networkModuleIndex];
                networkModule.start();
                ClientComms.this.receiver = new CommsReceiver(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getInputStream());
                ClientComms.this.receiver.start("MQTT Rec: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.sender = new CommsSender(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getOutputStream());
                ClientComms.this.sender.start("MQTT Snd: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.callback.start("MQTT Call: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.internalSend(this.conPacket, this.conToken);
            }
            catch (MqttException ex) {
                ClientComms.this.log.fine(CLASS_NAME, "connectBG:run", "212", null, ex);
                mqttEx = ex;
            }
            catch (Exception ex) {
                ClientComms.this.log.fine(CLASS_NAME, "connectBG:run", "209", null, ex);
                mqttEx = ExceptionHelper.createMqttException(ex);
            }
            if (mqttEx != null) {
                ClientComms.this.shutdownConnection(this.conToken, mqttEx, null);
            }
        }
    }

    private class DisconnectBG
    implements Runnable {
        MqttDisconnect disconnect;
        long quiesceTimeout;
        MqttToken token;
        private String threadName;

        DisconnectBG(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token, ExecutorService executorService) {
            this.disconnect = disconnect;
            this.quiesceTimeout = quiesceTimeout;
            this.token = token;
        }

        void start() {
            this.threadName = "MQTT Disc: " + ClientComms.this.getClient().getClientId();
            if (ClientComms.this.executorService == null) {
                new Thread(this).start();
            } else {
                ClientComms.this.executorService.execute(this);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.threadName);
            ClientComms.this.log.fine(CLASS_NAME, "disconnectBG:run", "221");
            ClientComms.this.clientState.quiesce(this.quiesceTimeout);
            try {
                try {
                    ClientComms.this.internalSend(this.disconnect, this.token);
                    if (ClientComms.this.sender != null && ClientComms.this.sender.isRunning()) {
                        this.token.internalTok.waitUntilSent();
                    }
                }
                catch (MqttException mqttException) {
                    this.token.internalTok.markComplete(null, null);
                    if (ClientComms.this.sender == null || !ClientComms.this.sender.isRunning()) {
                        this.token.internalTok.notifyComplete();
                    }
                    ClientComms.this.shutdownConnection(this.token, null, null);
                }
            }
            finally {
                this.token.internalTok.markComplete(null, null);
                if (ClientComms.this.sender == null || !ClientComms.this.sender.isRunning()) {
                    this.token.internalTok.notifyComplete();
                }
                ClientComms.this.shutdownConnection(this.token, null, null);
            }
        }
    }

    class ReconnectDisconnectedBufferCallback
    implements IDisconnectedBufferCallback {
        final String methodName;

        ReconnectDisconnectedBufferCallback(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void publishBufferedMessage(BufferedMessage bufferedMessage) throws MqttException {
            if (!ClientComms.this.isConnected()) {
                ClientComms.this.log.fine(CLASS_NAME, this.methodName, "208");
                throw ExceptionHelper.createMqttException(32104);
            }
            ClientComms.this.log.fine(CLASS_NAME, this.methodName, "510", new Object[]{bufferedMessage.getMessage().getKey()});
            ClientComms.this.internalSend(bufferedMessage.getMessage(), bufferedMessage.getToken());
            ClientComms.this.clientState.unPersistBufferedMessage(bufferedMessage.getMessage());
        }
    }
}

