/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.RandomAccessReadDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.io.RandomAccessReadBuffer;

public class GlyphTable
extends TTFTable {
    public static final String TAG = "glyf";
    private GlyphData[] glyphs;
    private TTFDataStream data;
    private IndexToLocationTable loca;
    private int numGlyphs;
    private int cached = 0;
    private HorizontalMetricsTable hmt = null;
    private MaximumProfileTable maxp = null;
    private static final int MAX_CACHE_SIZE = 5000;
    private static final int MAX_CACHED_GLYPHS = 100;

    GlyphTable() {
    }

    @Override
    void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        this.loca = ttf.getIndexToLocation();
        this.numGlyphs = ttf.getNumberOfGlyphs();
        if (this.numGlyphs < 5000) {
            this.glyphs = new GlyphData[this.numGlyphs];
        }
        byte[] dataBytes = data.read((int)this.getLength());
        try (RandomAccessReadBuffer read = new RandomAccessReadBuffer(dataBytes);){
            this.data = new RandomAccessReadDataStream(read);
        }
        this.hmt = ttf.getHorizontalMetrics();
        this.maxp = ttf.getMaximumProfile();
        this.initialized = true;
    }

    public void setGlyphs(GlyphData[] glyphsValue) {
        this.glyphs = glyphsValue;
    }

    public GlyphData getGlyph(int gid) throws IOException {
        return this.getGlyph(gid, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GlyphData getGlyph(int gid, int level) throws IOException {
        if (gid < 0 || gid >= this.numGlyphs) {
            return null;
        }
        if (this.glyphs != null && this.glyphs[gid] != null) {
            return this.glyphs[gid];
        }
        TTFDataStream tTFDataStream = this.data;
        synchronized (tTFDataStream) {
            GlyphData glyph;
            long[] offsets = this.loca.getOffsets();
            if (offsets[gid] == offsets[gid + 1]) {
                glyph = new GlyphData();
                glyph.initEmptyData();
            } else {
                long currentPosition = this.data.getCurrentPosition();
                this.data.seek(offsets[gid]);
                glyph = this.getGlyphData(gid, level);
                this.data.seek(currentPosition);
            }
            if (this.glyphs != null && this.glyphs[gid] == null && this.cached < 100) {
                this.glyphs[gid] = glyph;
                ++this.cached;
            }
            return glyph;
        }
    }

    private GlyphData getGlyphData(int gid, int level) throws IOException {
        if (level > this.maxp.getMaxComponentDepth()) {
            throw new IOException("composite glyph maximum level reached");
        }
        GlyphData glyph = new GlyphData();
        int leftSideBearing = this.hmt == null ? 0 : this.hmt.getLeftSideBearing(gid);
        glyph.initData(this, this.data, leftSideBearing, level);
        if (glyph.getDescription().isComposite()) {
            glyph.getDescription().resolve();
        }
        return glyph;
    }
}

