/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pg.replication.slot;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pg.replication.slot.PgReplicationSlotConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.postgresql.PGProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.0.0", scheme="pg-replication-slot", title="PostgresSQL Replication Slot", syntax="pg-replication-slot:host:port/database/slot:outputPlugin", category={Category.DATABASE}, consumerOnly=true)
public class PgReplicationSlotEndpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PgReplicationSlotEndpoint.class);
    private static final Pattern URI_PATTERN = Pattern.compile("^pg-replication-slot:(//)?(?<host>[^:]*):?(?<port>\\d*)?/(?<database>\\w+)/(?<slot>\\w+):(?<plugin>\\w+).*$");
    @UriPath(description="Postgres host", label="common", defaultValue="localhost")
    private String host = "localhost";
    @UriPath(description="Postgres port", label="common", defaultValue="5432")
    private Integer port = 5432;
    @UriPath(description="Postgres database name", label="common")
    @Metadata(required=true)
    private String database;
    @UriPath
    @Metadata(description="Replication Slot name", label="common", required=true)
    private String slot;
    @UriPath
    @Metadata(description="Output plugin name", label="common", required=true)
    private String outputPlugin;
    @UriParam(description="Postgres user", label="common", defaultValue="postgres")
    private String user = "postgres";
    @UriParam(description="Postgres password", label="common", secret=true)
    private String password;
    @UriParam(label="advanced", defaultValue="10")
    private Integer statusInterval = 10;
    @UriParam(label="advanced", prefix="slotOptions.", multiValue=true)
    private Map<String, Object> slotOptions = Collections.emptyMap();
    @UriParam(label="advanced", defaultValue="true")
    private Boolean autoCreateSlot = true;

    public PgReplicationSlotEndpoint(String uri, Component component) {
        super(uri, component);
        this.parseUri(uri);
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer not supported");
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        PgReplicationSlotConsumer consumer = new PgReplicationSlotConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    Connection newDbConnection() throws SQLException {
        Properties props = new Properties();
        PGProperty.USER.set(props, this.getUser());
        PGProperty.PASSWORD.set(props, this.getPassword());
        PGProperty.ASSUME_MIN_SERVER_VERSION.set(props, "9.6");
        PGProperty.REPLICATION.set(props, "database");
        PGProperty.PREFER_QUERY_MODE.set(props, "simple");
        PGProperty.TCP_KEEP_ALIVE.set(props, true);
        return DriverManager.getConnection(String.format("jdbc:postgresql://%s:%d/%s", this.getHost(), this.getPort(), this.getDatabase()), props);
    }

    protected final void parseUri(String uri) {
        LOG.debug("URI: {}", (Object)uri);
        Matcher matcher = URI_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The provided URL does not match the acceptable pattern");
        }
        if (matcher.group("host").length() > 0) {
            this.setHost(matcher.group("host"));
        }
        if (matcher.group("port").length() > 0) {
            this.setPort(Integer.valueOf(matcher.group("port")));
        }
        this.setDatabase(matcher.group("database"));
        this.setSlot(matcher.group("slot"));
        this.setOutputPlugin(matcher.group("plugin"));
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getSlot() {
        return this.slot;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public String getOutputPlugin() {
        return this.outputPlugin;
    }

    public void setOutputPlugin(String outputPlugin) {
        this.outputPlugin = outputPlugin;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getStatusInterval() {
        return this.statusInterval;
    }

    public void setStatusInterval(Integer statusInterval) {
        this.statusInterval = statusInterval;
    }

    public Map<String, Object> getSlotOptions() {
        return this.slotOptions;
    }

    public void setSlotOptions(Map<String, Object> slotOptions) {
        this.slotOptions = slotOptions;
    }

    public Boolean getAutoCreateSlot() {
        return this.autoCreateSlot;
    }

    public void setAutoCreateSlot(Boolean autoCreateSlot) {
        this.autoCreateSlot = autoCreateSlot;
    }
}

