/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.LargeObject64;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.utils.guava.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class LargeObject {
    static final int INV_READ = 262144;
    static final int INV_WRITE = 131072;
    static final int SEEK_SET = 0;
    static final int SEEK_CUR = 1;
    static final int SEEK_END = 2;
    int oid;
    int fd;
    PGDirectConnection connection;

    static LargeObject open(PGDirectConnection connection, int oid) throws SQLException {
        int fd = LargeObject.open(connection, oid, 393216);
        if (fd == -1) {
            throw new SQLException("Unable to open large object");
        }
        if (connection.isServerMinimumVersion(9, 3)) {
            return new LargeObject64(connection, oid, fd);
        }
        return new LargeObject(connection, oid, fd);
    }

    LargeObject(PGDirectConnection connection, int oid, int fd) throws SQLException {
        this.oid = oid;
        this.fd = fd;
        this.connection = connection;
        LargeObject.ensurePrepared(connection, "lo.close", "select lo_close($1)", "int4");
        LargeObject.ensurePrepared(connection, "lo.lseek", "select lo_lseek($1,$2,$3)", "int4", "int4", "int4");
        LargeObject.ensurePrepared(connection, "lo.tell", "select lo_tell($1)", "int4");
        LargeObject.ensurePrepared(connection, "lo.read", "select loread($1,$2)", "int4", "int4");
        LargeObject.ensurePrepared(connection, "lo.write", "select lowrite($1,$2)", "int4", "bytea");
        LargeObject.ensurePrepared(connection, "lo.truncate", "select lo_truncate($1,$2)", "int4", "int4");
    }

    LargeObject dup() throws SQLException {
        return LargeObject.open(this.connection, this.oid);
    }

    static void ensurePrepared(PGDirectConnection conn, String name, String sql, String ... typeNames) throws SQLException {
        if (!conn.isUtilQueryPrepared(name)) {
            try {
                conn.prepareUtilQuery(name, sql, typeNames);
            }
            catch (IOException e) {
                throw ErrorUtils.makeSQLException(e);
            }
        }
    }

    static int creat(PGDirectConnection conn, int mode) throws SQLException {
        LargeObject.ensurePrepared(conn, "lo.creat", "select lo_creat($1)", "int4");
        return conn.executeForValue("@lo.creat", Integer.class, mode);
    }

    static int open(PGDirectConnection conn, int oid, int access) throws SQLException {
        LargeObject.ensurePrepared(conn, "lo.open", "select lo_open($1,$2)", "oid", "int4");
        return conn.executeForValue("@lo.open", Integer.class, oid, access);
    }

    static int unlink(PGDirectConnection conn, int oid) throws SQLException {
        LargeObject.ensurePrepared(conn, "lo.unlink", "select lo_unlink($1)", "oid");
        return conn.executeForValue("@lo.unlink", Integer.class, oid);
    }

    int close() throws SQLException {
        return this.connection.executeForValue("@lo.close", Integer.class, this.fd);
    }

    long lseek(long offset, int whence) throws SQLException {
        return this.connection.executeForValue("@lo.lseek", Integer.class, this.fd, (int)offset, whence).intValue();
    }

    long tell() throws SQLException {
        return this.connection.executeForValue("@lo.tell", Integer.class, this.fd).intValue();
    }

    byte[] read(long len) throws SQLException {
        byte[] byArray;
        block8: {
            InputStream data = this.connection.executeForValue("@lo.read", InputStream.class, this.fd, (int)len);
            try {
                byArray = ByteStreams.toByteArray(data);
                if (data == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (data != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
            data.close();
        }
        return byArray;
    }

    int write(byte[] data, int off, int len) throws SQLException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream(data, off, len);
        return this.connection.executeForValue("@lo.write", Integer.class, this.fd, dataIn);
    }

    int truncate(long len) throws SQLException {
        return this.connection.executeForValue("@lo.truncate", Integer.class, this.fd, (int)len);
    }
}

