/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.sasl.scram;

import com.impossibl.postgres.protocol.sasl.scram.ScramMechanism;
import com.impossibl.postgres.protocol.sasl.scram.stringprep.StringPreparation;
import com.impossibl.postgres.protocol.sasl.scram.util.CryptoUtil;
import com.impossibl.postgres.protocol.sasl.scram.util.Preconditions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public enum ScramMechanisms implements ScramMechanism
{
    SCRAM_SHA_1("SHA-1", "SHA-1", 160, "HmacSHA1", false),
    SCRAM_SHA_1_PLUS("SHA-1", "SHA-1", 160, "HmacSHA1", true),
    SCRAM_SHA_256("SHA-256", "SHA-256", 256, "HmacSHA256", false),
    SCRAM_SHA_256_PLUS("SHA-256", "SHA-256", 256, "HmacSHA256", true);

    private static final String NAME_PREFIX = "SCRAM-";
    private static final String CHANNEL_BINDING_SUFFIX = "-PLUS";
    private static final String PBKDF2_ALGORITHM_PREFIX = "PBKDF2With";
    private static final Map<String, ScramMechanisms> BY_NAME_MAPPING;
    private final String mechanismName;
    private final String hashAlgorithmName;
    private final int keyLength;
    private final String hmacAlgorithmName;
    private final boolean channelBinding;

    private ScramMechanisms(String name, String hashAlgorithmName, int keyLength, String hmacAlgorithmName, boolean channelBinding) {
        this.mechanismName = NAME_PREFIX + Preconditions.checkNotNull(name, "name") + (channelBinding ? CHANNEL_BINDING_SUFFIX : "");
        this.hashAlgorithmName = Preconditions.checkNotNull(hashAlgorithmName, "hashAlgorithmName");
        this.keyLength = Preconditions.gt0(keyLength, "keyLength");
        this.hmacAlgorithmName = Preconditions.checkNotNull(hmacAlgorithmName, "hmacAlgorithmName");
        this.channelBinding = channelBinding;
    }

    protected String getHashAlgorithmName() {
        return this.hashAlgorithmName;
    }

    protected String getHmacAlgorithmName() {
        return this.hmacAlgorithmName;
    }

    @Override
    public String getName() {
        return this.mechanismName;
    }

    @Override
    public boolean requiresChannelBinding() {
        return this.channelBinding;
    }

    @Override
    public int algorithmKeyLength() {
        return this.keyLength;
    }

    @Override
    public byte[] digest(byte[] message) {
        try {
            return MessageDigest.getInstance(this.hashAlgorithmName).digest(message);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm " + this.hashAlgorithmName + " not present in current JVM");
        }
    }

    @Override
    public byte[] hmac(byte[] key, byte[] message) {
        try {
            return CryptoUtil.hmac(new SecretKeySpec(key, this.hmacAlgorithmName), Mac.getInstance(this.hmacAlgorithmName), message);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MAC Algorithm " + this.hmacAlgorithmName + " not present in current JVM");
        }
    }

    @Override
    public byte[] saltedPassword(StringPreparation stringPreparation, String password, byte[] salt, int iterations) {
        String keyFactoryAlgorithmName = PBKDF2_ALGORITHM_PREFIX + this.hmacAlgorithmName;
        char[] normalizedString = stringPreparation.normalize(password).toCharArray();
        try {
            return CryptoUtil.hi(SecretKeyFactory.getInstance(keyFactoryAlgorithmName), this.algorithmKeyLength(), normalizedString, salt, iterations);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("PBKDF Algorithm " + keyFactoryAlgorithmName + " not present in current JVM");
        }
    }

    public static ScramMechanisms byName(String name) {
        Preconditions.checkNotNull(name, "name");
        return BY_NAME_MAPPING.get(name);
    }

    private static Map<String, ScramMechanisms> valuesAsMap() {
        HashMap<String, ScramMechanisms> mapScramMechanisms = new HashMap<String, ScramMechanisms>(ScramMechanisms.values().length);
        for (ScramMechanisms scramMechanisms : ScramMechanisms.values()) {
            mapScramMechanisms.put(scramMechanisms.getName(), scramMechanisms);
        }
        return mapScramMechanisms;
    }

    static {
        BY_NAME_MAPPING = ScramMechanisms.valuesAsMap();
    }
}

