/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.NoticeException;
import java.io.IOException;
import java.util.Collections;

public class CloseRequest
implements ServerRequest {
    private ServerObjectType objectType;
    private String objectName;
    private RequestExecutor.SynchronizedHandler handler;

    CloseRequest(ServerObjectType objectType, String objectName, RequestExecutor.SynchronizedHandler handler) {
        this.objectType = objectType;
        this.objectName = objectName;
        this.handler = handler;
    }

    @Override
    public ProtocolHandler createHandler() {
        return this.handler != null ? new SyncedHandler() : new LazyHandler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeClose(this.objectType, this.objectName);
        if (this.handler != null) {
            channel.writeSync().flush();
        }
    }

    class SyncedHandler
    implements ProtocolHandler.CloseComplete,
    ProtocolHandler.CommandError,
    ProtocolHandler.ReadyForQuery {
        SyncedHandler() {
        }

        public String toString() {
            return "Close " + (Object)((Object)CloseRequest.this.objectType) + ": (Synchronized)";
        }

        @Override
        public ProtocolHandler.Action closeComplete() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action error(Notice notice) throws IOException {
            CloseRequest.this.handler.handleError(new NoticeException(notice), Collections.emptyList());
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            CloseRequest.this.handler.handleReady(txnStatus);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            CloseRequest.this.handler.handleError(cause, Collections.emptyList());
        }
    }

    class LazyHandler
    implements ProtocolHandler.CloseComplete,
    ProtocolHandler.CommandError {
        LazyHandler() {
        }

        public String toString() {
            return "Close " + (Object)((Object)CloseRequest.this.objectType);
        }

        @Override
        public ProtocolHandler.Action closeComplete() {
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action error(Notice notice) {
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) {
        }
    }
}

