/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.FieldFormats;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.protocol.v30.BufferRowData;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.system.NoticeException;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ExecutePortalRequest
implements ServerRequest {
    private String portalName;
    private int maxRows;
    private RequestExecutor.ExtendedQueryHandler handler;
    private ResultField[] describedResultFields;
    private RowDataSet rows;
    private List<Notice> notices;

    ExecutePortalRequest(String portalName, int maxRows, RequestExecutor.ExtendedQueryHandler handler) {
        this.portalName = portalName;
        this.maxRows = maxRows;
        this.handler = handler;
        this.describedResultFields = Empty.EMPTY_FIELDS;
        this.rows = new RowDataSet();
        this.notices = new ArrayList<Notice>();
    }

    private boolean isSynchronized() {
        return this.maxRows == 0;
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeDescribe(ServerObjectType.Portal, this.portalName).writeExecute(this.portalName, this.maxRows);
        if (!this.isSynchronized()) {
            channel.writeFlush();
        } else {
            channel.writeSync();
        }
        channel.flush();
    }

    static /* synthetic */ ResultField[] access$102(ExecutePortalRequest x0, ResultField[] x1) {
        x0.describedResultFields = x1;
        return x1;
    }

    private class Handler
    implements ProtocolHandler.RowDescription,
    ProtocolHandler.NoData,
    ProtocolHandler.DataRow,
    ProtocolHandler.EmptyQuery,
    ProtocolHandler.PortalSuspended,
    ProtocolHandler.CommandComplete,
    ProtocolHandler.ReportNotice,
    ProtocolHandler.CommandError,
    ProtocolHandler.ReadyForQuery {
        private Handler() {
        }

        public String toString() {
            return "Execute Portal";
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            ExecutePortalRequest.this.notices.add(notice);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action rowDescription(ResultField[] fields) {
            ExecutePortalRequest.access$102(ExecutePortalRequest.this, fields);
            FieldFormat[] effectiveFormats = FieldFormats.REQUEST_ALL_TEXT;
            for (int idx = 0; idx < ExecutePortalRequest.this.describedResultFields.length; ++idx) {
                FieldFormat format = effectiveFormats[Integer.min(idx, effectiveFormats.length - 1)].getFormat();
                ExecutePortalRequest.this.describedResultFields[idx].setFormat(format);
            }
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action rowData(ByteBuf data) {
            ExecutePortalRequest.this.rows.add(new BufferRowData(data.retain()));
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action noData() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action portalSuspended() throws IOException {
            try {
                ExecutePortalRequest.this.handler.handleSuspend(new TypeRef[0], ExecutePortalRequest.this.describedResultFields, ExecutePortalRequest.this.rows, ExecutePortalRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ExecutePortalRequest.this.rows);
            }
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action emptyQuery() throws IOException {
            return this.commandComplete(null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProtocolHandler.Action commandComplete(String command, Long rowsAffected, Long insertedOid) throws IOException {
            try {
                ExecutePortalRequest.this.handler.handleComplete(command, rowsAffected, insertedOid, new TypeRef[0], ExecutePortalRequest.this.describedResultFields, ExecutePortalRequest.this.rows, ExecutePortalRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ExecutePortalRequest.this.rows);
            }
            return ExecutePortalRequest.this.isSynchronized() ? ProtocolHandler.Action.Resume : ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action error(Notice error) throws IOException {
            try {
                ExecutePortalRequest.this.handler.handleError(new NoticeException(error), ExecutePortalRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ExecutePortalRequest.this.rows);
            }
            return ExecutePortalRequest.this.isSynchronized() ? ProtocolHandler.Action.Resume : ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            ExecutePortalRequest.this.handler.handleReady(txnStatus);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            try {
                ExecutePortalRequest.this.handler.handleError(cause, ExecutePortalRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ExecutePortalRequest.this.rows);
            }
        }
    }
}

