/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.AutoConvertingEncoder;
import com.impossibl.postgres.system.procs.ContextConversionFunction;
import com.impossibl.postgres.system.procs.ConversionFunction;

class NumericEncodingConverter<N extends Number>
implements AutoConvertingEncoder.Converter<N> {
    private ContextConversionFunction<String, N> stringCast;
    private ConversionFunction<Boolean, N> boolCast;
    private ConversionFunction<Number, N> numberCast;

    NumericEncodingConverter(ContextConversionFunction<String, N> stringCast, ConversionFunction<Boolean, N> boolCast, ConversionFunction<Number, N> numberCast) {
        this.stringCast = stringCast;
        this.boolCast = boolCast;
        this.numberCast = numberCast;
    }

    @Override
    public N convert(Context context, Object source, Object sourceContext) throws ConversionException {
        if (source instanceof String) {
            return (N)((Number)this.stringCast.apply(context, (String)source));
        }
        if (source instanceof Boolean) {
            return (N)((Number)this.boolCast.apply((Boolean)source));
        }
        if (source instanceof Number) {
            return (N)((Number)this.numberCast.apply((Number)source));
        }
        return null;
    }
}

