/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.GeometryParsers;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Points
extends SimpleProcProvider {
    public Points() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "point_");
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            double[] point = (double[])value;
            if (point.length != 2) {
                throw new IOException("invalid length");
            }
            buffer.append('(').append(point[0]).append(',').append(point[1]).append(')');
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return double[].class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return GeometryParsers.INSTANCE.parsePoint(buffer);
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
            super(16);
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            double[] point = (double[])value;
            if (point.length != 2) {
                throw new IOException("invalid length");
            }
            buffer.writeDouble(point[0]);
            buffer.writeDouble(point[1]);
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
            super(16);
        }

        @Override
        public Class<?> getDefaultClass() {
            return double[].class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return new double[]{buffer.readDouble(), buffer.readDouble()};
        }
    }
}

