/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.DatesTimes;
import com.impossibl.postgres.system.procs.SettingSelectProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public class TimestampsWithoutTZ
extends SettingSelectProcProvider {
    public TimestampsWithoutTZ() {
        super(ServerInfo::hasIntegerDateTimes, new TxtEncoder(), new TxtDecoder(), new BinEncoder(), new BinDecoder(), new TxtEncoder(), new TxtDecoder(), null, null, "timestamp_");
    }

    private static LocalDateTime convertInput(Context context, Type type, Object value, Calendar sourceCalendar) throws ConversionException {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof CharSequence) {
            CharSequence chars = (CharSequence)value;
            if (value.equals("infinity")) {
                return LocalDateTime.MAX;
            }
            if (value.equals("-infinity")) {
                return LocalDateTime.MIN;
            }
            TemporalAccessor parsed = context.getClientTimestampFormat().getParser().parse(chars);
            return LocalDateTime.from(parsed);
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            if (ts.getTime() == 9223372036825200000L) {
                return LocalDateTime.MAX;
            }
            if (ts.getTime() == -9223372036832400000L) {
                return LocalDateTime.MIN;
            }
            return ts.toInstant().atZone(sourceCalendar.getTimeZone().toZoneId()).toLocalDateTime();
        }
        if (value instanceof Time) {
            Time t = (Time)value;
            if (t.getTime() == 9223372036825200000L) {
                return LocalDateTime.MAX;
            }
            if (t.getTime() == -9223372036832400000L) {
                return LocalDateTime.MIN;
            }
            return Instant.ofEpochMilli(t.getTime()).atZone(sourceCalendar.getTimeZone().toZoneId()).toLocalDateTime();
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            if (d.getTime() == 9223372036825200000L) {
                return LocalDateTime.MAX;
            }
            if (d.getTime() == -9223372036832400000L) {
                return LocalDateTime.MIN;
            }
            return Instant.ofEpochMilli(d.getTime()).atZone(sourceCalendar.getTimeZone().toZoneId()).toLocalDateTime();
        }
        throw new ConversionException(value.getClass(), type);
    }

    private static Object convertInfinityOutput(boolean positive, Type type, Class<?> targetClass) throws ConversionException {
        if (targetClass == LocalDateTime.class) {
            return positive ? LocalDateTime.MAX : LocalDateTime.MIN;
        }
        if (targetClass == LocalDate.class) {
            return positive ? LocalDate.MAX : LocalDate.MIN;
        }
        if (targetClass == String.class) {
            return positive ? "infinity" : "-infinity";
        }
        if (targetClass == Time.class) {
            return new Time(positive ? 9223372036825200000L : -9223372036832400000L);
        }
        if (targetClass == Date.class) {
            return new Date(positive ? 9223372036825200000L : -9223372036832400000L);
        }
        if (targetClass == Timestamp.class) {
            return new Timestamp(positive ? 9223372036825200000L : -9223372036832400000L);
        }
        throw new ConversionException(type, targetClass);
    }

    private static Object convertOutput(Context context, Type type, LocalDateTime dateTime, Class<?> targetClass, Calendar targetCalendar) throws ConversionException {
        if (targetClass == LocalDateTime.class) {
            return dateTime;
        }
        if (targetClass == LocalDate.class) {
            return dateTime.toLocalDate();
        }
        if (targetClass == String.class) {
            return context.getClientTimestampFormat().getPrinter().format(dateTime);
        }
        ZoneId targetZoneId = targetCalendar.getTimeZone().toZoneId();
        ZonedDateTime zonedDateTime = dateTime.atOffset(ZoneOffset.UTC).atZoneSimilarLocal(targetZoneId);
        if (targetClass == Time.class) {
            return new Time(zonedDateTime.withYear(1970).withDayOfYear(1).toInstant().toEpochMilli());
        }
        if (targetClass == Date.class) {
            return new Date(zonedDateTime.truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli());
        }
        if (targetClass == Timestamp.class) {
            return Timestamp.from(zonedDateTime.toInstant());
        }
        throw new ConversionException(type, targetClass);
    }

    private static class TxtEncoder
    extends BaseTextEncoder {
        private TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            Calendar calendar = sourceContext != null ? (Calendar)sourceContext : Calendar.getInstance();
            LocalDateTime dateTime = TimestampsWithoutTZ.convertInput(context, type, value, calendar);
            if (dateTime.equals(LocalDateTime.MAX)) {
                buffer.append("infinity");
            } else if (dateTime.equals(LocalDateTime.MIN)) {
                buffer.append("-infinity");
            } else {
                String strVal = context.getServerTimestampFormat().getPrinter().format(dateTime);
                buffer.append(strVal);
            }
        }
    }

    private static class TxtDecoder
    extends BaseTextDecoder {
        private TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Timestamp.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Calendar calendar;
            Calendar calendar2 = calendar = targetContext != null ? (Calendar)targetContext : Calendar.getInstance();
            if (buffer.equals("infinity") || buffer.equals("-infinity")) {
                return TimestampsWithoutTZ.convertInfinityOutput(buffer.equals("infinity"), type, targetClass);
            }
            TemporalAccessor parsed = context.getServerTimestampFormat().getParser().parse(buffer);
            LocalDateTime localDateTime = LocalDateTime.from(parsed);
            return TimestampsWithoutTZ.convertOutput(context, type, localDateTime, targetClass, calendar);
        }
    }

    private static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
            super(8);
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            long micros;
            Calendar calendar = sourceContext != null ? (Calendar)sourceContext : Calendar.getInstance();
            LocalDateTime dateTime = TimestampsWithoutTZ.convertInput(context, type, value, calendar);
            if (dateTime.equals(LocalDateTime.MAX)) {
                micros = Long.MAX_VALUE;
            } else if (dateTime.equals(LocalDateTime.MIN)) {
                micros = Long.MIN_VALUE;
            } else {
                long seconds = DatesTimes.javaEpochToPg(dateTime.toEpochSecond(ZoneOffset.UTC), TimeUnit.SECONDS);
                micros = TimeUnit.SECONDS.toMicros(seconds) + TimeUnit.NANOSECONDS.toMicros(dateTime.getNano() + 500);
            }
            buffer.writeLong(micros);
        }
    }

    private static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
            super(8);
        }

        @Override
        public Class<?> getDefaultClass() {
            return Timestamp.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            Calendar calendar = targetContext != null ? (Calendar)targetContext : Calendar.getInstance();
            long micros = buffer.readLong();
            if (micros == Long.MAX_VALUE || micros == Long.MIN_VALUE) {
                return TimestampsWithoutTZ.convertInfinityOutput(micros == Long.MAX_VALUE, type, targetClass);
            }
            micros = DatesTimes.pgEpochToJava(micros, TimeUnit.MICROSECONDS);
            long secs = TimeUnit.MICROSECONDS.toSeconds(micros);
            long nanos = TimeUnit.MICROSECONDS.toNanos(micros % TimeUnit.SECONDS.toMicros(1L));
            if (nanos < 0L) {
                nanos += TimeUnit.SECONDS.toNanos(1L);
                --secs;
            }
            LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(secs, (int)nanos, ZoneOffset.UTC);
            return TimestampsWithoutTZ.convertOutput(context, type, localDateTime, targetClass, calendar);
        }
    }
}

