/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.tables;

import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.system.tables.Table;
import com.impossibl.postgres.system.tables.Tables;
import java.io.IOException;

public class PGTypeTable
implements Table<Row> {
    private static final int OID = 0;
    private static final int NAME = 1;
    private static final int LENGTH = 2;
    private static final int DISCRIMINATOR = 3;
    private static final int CATEGORY = 4;
    private static final int DELIMINATOR = 5;
    private static final int RELATION_ID = 6;
    private static final int ELEMENT_TYPE_ID = 7;
    private static final int ARRAY_TYPE_ID = 8;
    private static final int INPUT_ID = 9;
    private static final int OUTPUT_ID = 10;
    private static final int RECEIVE_ID = 11;
    private static final int SEND_ID = 12;
    private static final int MOD_IN_ID = 13;
    private static final int MOD_OUT_ID = 14;
    private static final int ALIGNMENT = 15;
    private static final int NAMESPACE = 16;
    private static final int DOMAIN_BASE_TYPE_ID = 17;
    private static final int DOMAIN_TYPE_MOD = 18;
    private static final int DOMAIN_NOT_NULL = 19;
    private static final int DOMAIN_DEFAULT = 20;
    private static final int RANGE_BASE_TYPE_ID = 21;
    public static final PGTypeTable INSTANCE = new PGTypeTable();
    public static final Object[] SQL = new Object[]{Version.get(9, 2, 0), " SELECT t.oid, typname, typlen, typtype, typcategory, typdelim, typrelid, typelem, typarray, typinput::text, typoutput::text, typreceive::text, typsend::text, typmodin::text, typmodout::text, typalign, n.nspname, typbasetype, typtypmod, typnotnull, pg_catalog.pg_get_expr(typdefaultbin,0), rngsubtype FROM   pg_catalog.pg_type t LEFT JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid) LEFT JOIN pg_catalog.pg_range r ON (t.oid = r.rngtypid)", Version.get(9, 1, 0), " SELECT t.oid, typname, typlen, typtype, typcategory, typdelim, typrelid, typelem, typarray, typinput::text, typoutput::text, typreceive::text, typsend::text, typmodin::text, typmodout::text, typalign, n.nspname, typbasetype, typtypmod, typnotnull, pg_catalog.pg_get_expr(typdefaultbin,0), NULL FROM   pg_catalog.pg_type t LEFT JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid)"};

    private PGTypeTable() {
    }

    @Override
    public String getSQL(Version currentVersion) {
        return Tables.getSQL(SQL, currentVersion);
    }

    @Override
    public Row createRow(Context context, ResultBatch resultBatch, int rowIdx) throws IOException {
        Row row = new Row();
        row.load(context, resultBatch, rowIdx);
        return row;
    }

    public static class Row
    implements Table.Row {
        private int oid;
        private String name;
        private short length;
        private String discriminator;
        private String category;
        private String deliminator;
        private int relationId;
        private int elementTypeId;
        private int arrayTypeId;
        private String inputId;
        private String outputId;
        private String receiveId;
        private String sendId;
        private String modInId;
        private String modOutId;
        private String alignment;
        private String namespace;
        private int domainBaseTypeId;
        private int domainTypeMod;
        private boolean domainNotNull;
        private String domainDefault;
        private Integer rangeBaseTypeId;

        public Integer getReferencingTypeOid() {
            if (this.category.equals("A")) {
                return this.elementTypeId;
            }
            switch (this.discriminator) {
                case "d": {
                    return this.domainBaseTypeId;
                }
                case "r": {
                    return this.rangeBaseTypeId;
                }
            }
            return null;
        }

        public boolean isPsuedo() {
            return this.discriminator.equals("p");
        }

        public boolean isBase() {
            return this.discriminator.equals("b");
        }

        public boolean isArray() {
            return this.category.equals("A");
        }

        @Override
        public void load(Context context, ResultBatch resultBatch, int rowIdx) throws IOException {
            this.oid = Table.getFieldOfRow(resultBatch, rowIdx, 0, context, Integer.class);
            this.name = Table.getFieldOfRow(resultBatch, rowIdx, 1, context, String.class);
            this.length = Table.getFieldOfRow(resultBatch, rowIdx, 2, context, Short.class);
            this.discriminator = Table.getFieldOfRow(resultBatch, rowIdx, 3, context, String.class);
            this.category = Table.getFieldOfRow(resultBatch, rowIdx, 4, context, String.class);
            this.deliminator = Table.getFieldOfRow(resultBatch, rowIdx, 5, context, String.class);
            this.relationId = Table.getFieldOfRow(resultBatch, rowIdx, 6, context, Integer.class);
            this.elementTypeId = Table.getFieldOfRow(resultBatch, rowIdx, 7, context, Integer.class);
            this.arrayTypeId = Table.getFieldOfRow(resultBatch, rowIdx, 8, context, Integer.class);
            this.inputId = Table.getFieldOfRow(resultBatch, rowIdx, 9, context, String.class);
            this.outputId = Table.getFieldOfRow(resultBatch, rowIdx, 10, context, String.class);
            this.receiveId = Table.getFieldOfRow(resultBatch, rowIdx, 11, context, String.class);
            this.sendId = Table.getFieldOfRow(resultBatch, rowIdx, 12, context, String.class);
            this.modInId = Table.getFieldOfRow(resultBatch, rowIdx, 13, context, String.class);
            this.modOutId = Table.getFieldOfRow(resultBatch, rowIdx, 14, context, String.class);
            this.alignment = Table.getFieldOfRow(resultBatch, rowIdx, 15, context, String.class);
            this.domainBaseTypeId = Table.getFieldOfRow(resultBatch, rowIdx, 17, context, Integer.class);
            this.domainTypeMod = Table.getFieldOfRow(resultBatch, rowIdx, 18, context, Integer.class);
            this.domainNotNull = Table.getFieldOfRow(resultBatch, rowIdx, 19, context, Boolean.class);
            this.namespace = Table.getFieldOfRow(resultBatch, rowIdx, 16, context, String.class);
            this.domainDefault = Table.getFieldOfRow(resultBatch, rowIdx, 20, context, String.class);
            this.rangeBaseTypeId = Table.getFieldOfRow(resultBatch, rowIdx, 21, context, Integer.class);
        }

        public int getOid() {
            return this.oid;
        }

        public void setOid(int v) {
            this.oid = v;
        }

        public String getName() {
            return this.name;
        }

        public short getLength() {
            return this.length;
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public String getCategory() {
            return this.category;
        }

        public String getDeliminator() {
            return this.deliminator;
        }

        public int getRelationId() {
            return this.relationId;
        }

        public int getElementTypeId() {
            return this.elementTypeId;
        }

        public int getArrayTypeId() {
            return this.arrayTypeId;
        }

        public String getInputId() {
            return this.inputId;
        }

        public String getOutputId() {
            return this.outputId;
        }

        public String getReceiveId() {
            return this.receiveId;
        }

        public String getSendId() {
            return this.sendId;
        }

        public String getModInId() {
            return this.modInId;
        }

        public String getModOutId() {
            return this.modOutId;
        }

        public String getAlignment() {
            return this.alignment;
        }

        public int getDomainBaseTypeId() {
            return this.domainBaseTypeId;
        }

        public int getDomainTypeMod() {
            return this.domainTypeMod;
        }

        public boolean isDomainNotNull() {
            return this.domainNotNull;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getDomainDefault() {
            return this.domainDefault;
        }

        public Integer getRangeBaseTypeId() {
            return this.rangeBaseTypeId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Row other = (Row)obj;
            return this.oid == other.oid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.oid;
            return result;
        }
    }
}

