/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.system.tables.PGTypeTable;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import java.io.IOException;
import java.util.Map;

public class DomainType
extends Type {
    private Type base;
    private boolean nullable;
    private Map<String, Object> modifiers;
    private String defaultValue;

    public Type getBase() {
        return this.base;
    }

    @Override
    public Boolean isNullable() {
        return this.nullable;
    }

    public Map<String, Object> getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isParameterFormatSupported(FieldFormat format) {
        return this.base.isParameterFormatSupported(format);
    }

    @Override
    public boolean isResultFormatSupported(FieldFormat format) {
        return this.base.isResultFormatSupported(format);
    }

    @Override
    public Type unwrap() {
        return this.base.unwrap();
    }

    @Override
    public void load(PGTypeTable.Row source, Registry registry) throws IOException {
        super.load(source, registry);
        this.base = registry.loadType(source.getDomainBaseTypeId());
        this.nullable = !source.isDomainNotNull();
        this.modifiers = this.base.getModifierParser().parse(source.getDomainTypeMod());
        this.defaultValue = source.getDomainDefault() != null ? source.getDomainDefault() : "";
    }
}

