/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.QualifiedName;
import com.impossibl.postgres.types.SharedRegistry;
import com.impossibl.postgres.types.Type;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Registry {
    private SharedRegistry sharedRegistry;
    private Map<String, Type> commonTypes;
    private TypeLoader loader;

    public Registry(SharedRegistry sharedRegistry, TypeLoader loader) {
        this.sharedRegistry = sharedRegistry;
        this.commonTypes = new HashMap<String, Type>();
        this.loader = loader;
    }

    public SharedRegistry getShared() {
        return this.sharedRegistry;
    }

    public Type resolve(TypeRef typeRef) throws IOException {
        if (typeRef instanceof Type) {
            return (Type)typeRef;
        }
        return this.loadType(typeRef.getOid());
    }

    public Type loadType(int typeId) throws IOException {
        if (typeId == 0) {
            return null;
        }
        return this.sharedRegistry.findOrLoadType(typeId, this.loader);
    }

    public Type loadBaseType(String localName) {
        Type type;
        QualifiedName name = new QualifiedName("pg_catalog", localName);
        try {
            type = this.sharedRegistry.findOrLoadType(name, this.loader);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load base type: " + localName);
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown type");
        }
        return type;
    }

    public CompositeType loadRelationType(int relationId) throws IOException {
        if (relationId == 0) {
            return null;
        }
        return this.sharedRegistry.findOrLoadRelationType(relationId, this.loader);
    }

    public Type loadStableType(String typeName) throws IOException {
        Type type = this.commonTypes.get(typeName);
        if (type == null) {
            type = this.loadTransientType(typeName);
            this.commonTypes.put(typeName, type);
        }
        return type;
    }

    public Type loadTransientType(String typeName) throws IOException {
        return this.loader.load(typeName);
    }

    public static interface TypeLoader {
        public Type load(int var1) throws IOException;

        public CompositeType loadRelation(int var1) throws IOException;

        public Type load(QualifiedName var1) throws IOException;

        public Type load(String var1) throws IOException;
    }
}

