/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.IsSingleton;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.support.PollingConsumerSupport;
import org.apache.camel.support.service.ServiceHelper;

public class ProcessorPollingConsumer
extends PollingConsumerSupport
implements IsSingleton {
    private final Processor processor;

    public ProcessorPollingConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint);
        this.processor = processor;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    @Override
    public Exchange receive() {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(String.valueOf(this) + " is not started, but in state: " + this.getStatus().name());
        }
        Exchange exchange = this.getEndpoint().createExchange();
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Error while processing exchange", exchange, e);
        }
        return exchange;
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive();
    }

    @Override
    public Exchange receive(long timeout) {
        return this.receive();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

