/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.JDBCTypeMapping;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.TypeMapContext;
import com.impossibl.postgres.types.ArrayType;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public abstract class PGArray
implements Array {
    protected Context context;
    protected ArrayType type;

    PGArray(Context context, ArrayType type) {
        this.context = context;
        this.type = type;
    }

    public abstract int getLength();

    protected abstract Object getArray(Context var1, Class<?> var2, long var3, int var5) throws SQLException;

    protected abstract ResultSet getResultSet(Context var1, long var2, int var4) throws SQLException;

    protected void checkFreed() throws SQLException {
        if (this.context == null && this.type == null) {
            throw new PGSQLSimpleException("Array previously freed");
        }
    }

    public ArrayType getType() {
        return this.type;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkFreed();
        return this.type.getElementType().getName();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkFreed();
        return JDBCTypeMapping.getJDBCTypeCode(this.type.getElementType());
    }

    public Object getArray(Class<?> targetComponentType) throws SQLException {
        this.checkFreed();
        return this.getArray(this.context, targetComponentType, 1L, this.getLength());
    }

    @Override
    public Object getArray() throws SQLException {
        this.checkFreed();
        return this.getArray(this.context, null, 1L, this.getLength());
    }

    @Override
    public Object getArray(Map<String, Class<?>> typeMap) throws SQLException {
        this.checkFreed();
        return this.getArray(new TypeMapContext(this.context, typeMap), null, 1L, this.getLength());
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.checkFreed();
        return this.getArray(this.context, null, index, count);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> typeMap) throws SQLException {
        this.checkFreed();
        return this.getArray(new TypeMapContext(this.context, typeMap), null, index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkFreed();
        return this.getResultSet(this.context.getCustomTypeMap());
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> typeMap) throws SQLException {
        this.checkFreed();
        return this.getResultSet(new TypeMapContext(this.context, typeMap), 1L, this.getLength());
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        this.checkFreed();
        return this.getResultSet(this.context, index, count);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> typeMap) throws SQLException {
        this.checkFreed();
        return this.getResultSet(new TypeMapContext(this.context, typeMap), index, count);
    }
}

